<?php
/**
 * Template part for displaying posts
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package WP_Bootstrap_Starter
 */

?>
<!-- Blog Page Area Start -->
        <div class="blog-page-area section pt-100 pt-lg-80 pt-md-70 pt-sm-60 pt-xs-50  pb-80 pb-lg-60 pb-md-50 pb-sm-40 pb-xs-30">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="blog-area-wrap">
                            <div class="row">
                                <div class="blog col-lg-6 col-sm-6 col-12 mb-30 mb-xs-10">
                                    <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                                        <div class="blog-inner">
                                            <div class="post-thumbnail">
                                                <div class="media-image"><a href="#" class="image"><?php the_post_thumbnail(); ?></a></div>
                                            </div>
                                        
                                        <div class="content">
                                            <h3 class="title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                                            <ul class="meta">
                                                <li><i class="dlicon ui-2_time"></i> <a href="#"><?php echo get_the_date(); ?></a></li>
                                                <li>By <a href="#">admin</a></li>
                                                <li><i class="dlicon shopping_tag"></i> <a href="#">Furniture</a></li>
                                            </ul>
                                            <?php
        if ( is_single() ) :
			the_content();
        else :
            the_content( __( 'Continue reading <span class="meta-nav">&rarr;</span>', 'wp-bootstrap-starter' ) );
        endif;

			wp_link_pages( array(
				'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'wp-bootstrap-starter' ),
				'after'  => '</div>',
			) );
		?>
                                            <div class="blog-btn mt-0">
                                                <a href="<?php the_permalink(); ?>" class="read-more">Read More</a>
                                            </div>
                                        </div>
                                    </div>
                                    </article>
                                    
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-12">
                                    <div class="page-pagination-area">
                                        <ul class="page-pagination justify-content-center mt-0">
                                            <li class="active"><a href="#">1</a></li>
                                            <li><a href="#">2</a></li>
                                            <li><a href="#"><i class="dlicon arrows-1_tail-triangle-right"></i></a></li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Blog Page Area End -->

