<!DOCTYPE html>
<html class="no-js" <?php language_attributes(); ?>>

	<head>

		<meta charset="<?php bloginfo( 'charset' ); ?>">
		<meta name="viewport" content="width=device-width, initial-scale=1.0" >

		<link rel="profile" href="https://gmpg.org/xfn/11">
<link href="https://fonts.googleapis.com/css?family=Josefin+Sans:400,700%7cLora:400,700,700i&amp;display=swap" rel="stylesheet">
		<?php wp_head(); ?>

	</head>

<body <?php body_class(); ?>>
	<div id="main-wrapper" class="">

	<!--Header section start-->
			<header class="border-bottom header <?php if((is_front_page())){ echo '';}?>">
							<div class="container-fluid px-lg-5">
									<div class="row align-items-lg-end align-items-center">
											<div class="col-xl-2 col-lg-2 col-md-6 col-sm-6 col-12 col-xs-12 order-lg-2">
													<div class="logo py-1 mb-4 mt-3 mb-lg-0 mt-lg-0 text-center">
														<?php if ( has_custom_logo() ): ?>
											 <?php the_custom_logo(); ?>
									<?php else : ?>
										<h1>
											<a class="site-title text-uppercase" href="<?php echo esc_url( home_url( '/' )); ?>"><?php esc_url(bloginfo('name')); ?></a>
										</h1>
									<?php endif; ?>
													</div>
											</div>
											<div class="col-lg-5 col-md-0 py-2 d-none d-xl-block">
												<div class="menu-center d-flex justify-content-start">
												<nav class="main-menu">
															<?php
				 wp_nav_menu(array(
				 'theme_location'    => 'header-menu',
				 'container' => false,
	'items_wrap'      => '<ul id="navigation" class="">%3$s</ul>',
	'item_spacing'    => 'preserve',
	'depth'           => 0,
	'add_li_class'  => 'nav-item',
				 ));
				 ?>
				 </nav>
				 </div>
											</div>
											<div class="col-lg-5 col-md-6 col-sm-6 order-lg-3">
												<div class="row">
													<div class="col-xl-12 col-lg-12 py-2 col-md-12 col-12 col-xs-12 d-flex justify-content-lg-end justify-content-center">
														<?php
														if(!(is_user_logged_in())){
															?>
															<div class="header-icon mx-4">
																	<a class="login" href="<?php echo get_site_url(); ?>/my-account/customer-logout/?_wpnonce=fe255c8953">Login</a>
																	<a class="signup" href="#">Signup</a>
															</div>
															<?php
														}else{
															?>
															<div class="header-icon mx-4">
																	<a class="signup" href="<?php echo get_site_url(); ?>/my-account/customer-logout/?_wpnonce=fe255c8953">Logout</a>
															</div>
															<?php
														}
														?>
													<!--div class="header-icon search ">
															<a class="search-trigger" href="#">
																	<i class="dlicon ui-1_zoom"></i>
															</a>
													</div-->
													<!--div class="header-icon cart ">
															<a href="wishlist.html">
																	<span class="cart-count">3</span>
																	<i class="dlicon ui-3_heart"></i>
															</a>
													</div-->
													<div class="header-icon cart ">
														<?php if(class_exists( 'WooCommerce' )){
												do_action( 'scorpio_cart_count' );
												//do_action( 'scorpio_shop_woo_cart' );
												} ?>
															<!--a class="cart-trigger" href="#">
																	<span class="cart-count">3</span>
																	<i class="dlicon shopping_cart-modern"></i>
															</a-->
													</div>
													<div class="header-icon hamburger-menu ">
																<a class="hamburger-trigger d-none" href="#">
																		<i class="dlicon ui-3_menu"></i>
																</a>

																<a class="hamburger-trigger d-block d-xl-none" href="#">
																		<i class="dlicon ui-3_menu"></i>
																</a>
														</div>
											</div>
													<!--Menu start-->
													<div class="col-xl-12 col-lg-12 py-2  d-none d-xl-block">
															<div class="menu-center d-flex justify-content-end">
															<nav class="main-menu">
																		<?php
							 wp_nav_menu(array(
							 'theme_location'    => 'header-menu-right',
							 'container' => false,
			 'items_wrap'      => '<ul id="navigation" class="">%3$s</ul>',
			 'item_spacing'    => 'preserve',
			 'depth'           => 0,
			 'add_li_class'  => 'nav-item',
							 ));
							 ?>
							 </nav>
							 </div>
															</div>
												</div>

											</div>

											</div>
											<!--Menu end-->

									</div>
							</div>
					</div>
			</header>
			<!--Header section end-->
		<!-- Start Search Flyover -->
        <div class="search-flyoveray"></div>
			<div class="cart-flyout">
					<div class="cart-flyout-inner">
							<a class="btn-close-cart" href="#">
									<i class="dlicon ui-1_simple-remove"></i>
							</a>
							<div class="cart-flyout__content">
									<div class="cart-flyout__heading">Shopping Cart</div>
									<div class="widget_shopping_cart_content">
										<?php woocommerce_mini_cart();	?>
									</div>
							</div>
					</div>
			</div>
		<!-- Start Search FlyOver Area -->
        <div class="search-flyoverlay-area">
            <div class="btn-close-search">
                <i class="dlicon ui-1_simple-remove"></i>
            </div>
            <div class="searchform-fly">
                <p class="searchform-fly-text">Start typing and press Enter to search !</p>
                <form role="search" method="get" class="search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>">
                    <input type="text" placeholder="Search" value="<?php echo get_search_query(); ?>" name="s">
                    <button class="search-button" type="submit" value="<?php echo esc_attr_x( 'Search', 'submit button', 'woocommerce' ); ?>">
						<input type="hidden" name="post_type" value="product" />
                        <i class="dlicon ui-1_zoom"></i>
                    </button>
                </form>
            </div>
        </div>
        <!-- End Search FlyOver Area -->
		        <!-- Start Hamburger -->
        <div class="hamburger-area">
            <div class="btn-close-search">
                <button>
                    <i class="dlicon ui-1_simple-remove"></i>
                </button>
            </div>
            <div class="hamburger-menu-main d-none d-xl-block">
                <div class="humberger-top">
                    <div class="hum-mainmenu">
                        <?php
					 wp_nav_menu(array(
					 'theme_location'    => 'top-menu',
					 'container' => false,
	 'items_wrap'      => '<ul id="navigation" class="">%3$s</ul>',
	 'item_spacing'    => 'preserve',
	 'depth'           => 0,
	 'add_li_class'  => 'nav-item',
					 ));
					 ?>
                    </div>
                </div>

                <div class="humberger-banner">
                    <a href="#"><img src="assets/images/banner/img-hamburger-banner.jpg" alt=""></a>
                </div>

                <div class="humberger-bottom">
                    <div class="humberger-bottom__inner">
                        <div class="content">
                            <!--ul class="hm-address">
                                <li><a href="#"><span>(+91) 9988556677 </span></a></li>
                                <li><a href="#"><span>info@fishandhooks.com </span></a></li>
                                <li><a href="#"><span>PO Box 1622 Colins Street West <br> Chennai Tamilnadu</span></a></li>
                            </ul-->
                            <a class="gmap" href="#">Google map</a>
                            <div class="hamburger-social bg-owncolor">
                                <a class="facebook" href="#"><i class="fa fa-facebook"></i></a>
                                <a class="twitter" href="#"><i class="fa fa-twitter"></i></a>
                                <a class="pinterest" href="#"><i class="fa fa-pinterest"></i></a>
								<a class="instagram" href="#"><i class="fa fa-instagram"></i></a>
                                <a class="youtube" href="#"><i class="fa fa-youtube-play"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Start Main Menu -->

<div id="responsive-manu" class=" responsive-manu d-block d-xl-none">
            <?php
					 wp_nav_menu(array(
					 'theme_location'    => 'top-menu',
					 'container' => false,
	 'items_wrap'      => '<ul id="responsive-manu" class="menu-primary-menu-1 responsive-manu d-block d-xl-none">%3$s</ul>',
	 'item_spacing'    => 'preserve',
	 'depth'           => 0,
	 'add_li_class'  => 'nav-item',
					 ));
					 ?>
</div>
            <!-- End Main Menu -->
        </div>
        <!-- End Hamburger -->
	<?php if(!(is_front_page()||is_product())){ ?>
		<!-- Breadcrumb Section Start -->
        <div class="breadcrumb-section section bg-image" data-bg="./assets/images/bg/bg-title-shop.jpg">
            <div class="container">
                <div class="row">
                    <div class="col">

                        <div class="breadcrumb-title text-center">
                            <h1><?php
						if ( is_product_category() ) {
							single_cat_title();
						}
	else if ( is_post_type_archive() ) {
		if ( is_search()){
		woocommerce_page_title();
	} else{
		post_type_archive_title();
		}
	}
	else if(is_archive()){
		the_archive_title();
	}
	else if(is_home()){
		single_post_title();
	}

						else{
							the_title();
						}
						?> </h1>
							<?php if ( is_search()||is_product_category()||is_product() ||is_shop() ) {
				  //woocommerce_breadcrumb();
			  }else{ ?>
            <?php breadcrumb_trail();
}
						?>
                        </div>

                    </div>
                </div>
            </div>
        </div>
        <!-- Breadcrumb Section End -->
		<?php } ?>
