<!DOCTYPE html>
<html class="no-js" <?php language_attributes(); ?>>

	<head>

		<meta charset="<?php bloginfo( 'charset' ); ?>">
		<meta name="viewport" content="width=device-width, initial-scale=1.0" >

		<link rel="profile" href="https://gmpg.org/xfn/11">
<link href="https://fonts.googleapis.com/css?family=Josefin+Sans:400,700%7cLora:400,700,700i&amp;display=swap" rel="stylesheet">
		<?php wp_head(); ?>

	</head>

<body <?php body_class(); ?>>
	<div id="main-wrapper" class="">

	<!--Header section start-->
		<header class="header">
			<div class="header-deafult menu-right d-flex align-items-center">
				<div class="container-fluid px-0">
					<div class="row align-items-center py-2 px-lg-4">
						<div class="col-xl-3 col-lg-3 col-md-2">
							<div class="text-center py-1">
								<?php if ( has_custom_logo() ): ?>
									<?php the_custom_logo(); ?>
										<?php else : ?>
											<h1>
												<a class="site-title text-uppercase" href="<?php echo esc_url( home_url( '/' )); ?>"><?php esc_url(bloginfo('name')); ?></a>
											</h1>
										<?php endif; ?>
							</div>
						</div>
											<!--Menu start-->
						<div class="col-xl-5 order-2 order-md-1 justify-content-center">
							<div class="mx-auto">

								<div class="search-box my-2">
									<?php echo do_shortcode('[wpdreams_ajaxsearchlite]'); ?>
								</div>

							</div>
						</div>
						<div class="col-xl-4 col-lg-4 col-md-5 d-flex justify-content-end order-3 order-md-3">

									<!--Cart info Start -->
                                    <div class="cart-info d-flex">
                                        <div class="mini-cart-warp">
                                            <?php if(class_exists( 'WooCommerce' ))
											{
												do_action( 'scorpio_cart_count' );
											} ?>
											<div class="mini-cart-content">
												<?php woocommerce_mini_cart();	?>
											</div>
                                        </div>
                                    </div>
                                    <!--Cart info End -->
						</div>
					</div>
				<!-- Menu Content Start -->
                <div class="header-buttom-nav sticky-nav bg-theme-color">
                    <div class="px-lg-4">
                        <div class="row">
                            <div class="col-md-12 text-left d-none d-lg-block">
                                <div class="d-flex align-items-start justify-content-start">
                                    <!--Main Navigation Start -->
                                    <div class="main-navigation d-none d-lg-block">
                                        <?php
											wp_nav_menu(array(
												'theme_location'    => 'header-menu',
												'container' => false,
												'items_wrap'      => '<ul id="navigation" class="">%3$s</ul>',
												'item_spacing'    => 'preserve',
												'depth'           => 0,
												'add_li_class'  => 'nav-item',
											));
										?>
                                    </div>
                                    <!--Main Navigation End -->
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Menu Content End -->
				<!-- Header Buttom Start -->
                <div class="header-navigation sticky-nav bg-theme-color d-lg-none">
                    <div class="container position-relative">
                        <div class="row">
                            <!-- Navigation Start -->
                            <div class="col-md-12 col-sm-12">
                                <!--Header Bottom Account Start -->
                                <div class="header_account_area">
                                    <!--Cart info Start -->
                                    <div class="cart-info d-flex">
                                        <div class="mini-cart-warp">
                                            <?php if(class_exists( 'WooCommerce' ))
											{
												do_action( 'scorpio_cart_count' );
											} ?>
											<div class="mini-cart-content">
												<?php woocommerce_mini_cart();	?>
											</div>
                                        </div>
                                    </div>
                                </div>
                                <!--Cart info End -->
                            </div>
                        </div>
                        <!-- mobile menu -->
                        <div class="mobile-menu-area">
                            <div class="mobile-menu">
                                <nav id="mobile-menu-active">
									<?php
											wp_nav_menu(array(
												'theme_location'    => 'header-menu',
												'container' => false,
												'items_wrap'      => '<ul id="navigation" class="menu-overflow">%3$s</ul>',
												'item_spacing'    => 'preserve',
												'depth'           => 0,
												'add_li_class'  => 'nav-item',
											));
										?>
                                </nav>
                            </div>
                        </div>
                        <!-- mobile menu end-->
                    </div>
                </div>
                <!--Header Bottom Account End -->
				<!-- Beauty Category -->
                <div class="container d-lg-none">
                    <!--=======  category menu  =======-->
                    <div class="hero-side-category">
                        <!-- Category Toggle Wrap -->
                        <div class="category-toggle-wrap">
                            <!-- Category Toggle -->
                            <button class="category-toggle"><i class="fa fa-bars"></i> All Categories</button>
                        </div>

                        <!-- Category Menu -->
                        <nav class="category-menu">
							<?php
											wp_nav_menu(array(
												'theme_location'    => 'top-menu',
												'container' => false,
												'items_wrap'      => '<ul id="navigation" class="">%3$s</ul>',
												'item_spacing'    => 'preserve',
												'depth'           => 0,
												'add_li_class'  => 'nav-item',
												"walker"            => new My_Walker_Nav_Menu_Mobile(),
											));
										?>
                            <ul>
                                <li class="menu-item-has-children menu-item-has-children-1">
                                    <a href="#">Accessories & Parts<i class="ion-ios-arrow-down"></i></a>
                                    <!-- category submenu -->
                                    <ul class="category-mega-menu category-mega-menu-1">
                                        <li><a href="#">Cables & Adapters</a></li>
                                        <li><a href="#">Batteries</a></li>
                                        <li><a href="#">Chargers</a></li>
                                        <li><a href="#">Bags & Cases</a></li>
                                        <li><a href="#">Electronic Cigarettes</a></li>
                                    </ul>
                                </li>
                                <li class="menu-item-has-children menu-item-has-children-2">
                                    <a href="#">Camera & Photo<i class="ion-ios-arrow-down"></i></a>
                                    <!-- category submenu -->
                                    <ul class="category-mega-menu category-mega-menu-2">
                                        <li><a href="#">Digital Cameras</a></li>
                                        <li><a href="#">Camcorders</a></li>
                                        <li><a href="#">Camera Drones</a></li>
                                        <li><a href="#">Action Cameras</a></li>
                                        <li><a href="#">Photo Studio Supplies</a></li>
                                    </ul>
                                </li>
                                <li class="menu-item-has-children menu-item-has-children-3">
                                    <a href="#">Smart Electronics <i class="ion-ios-arrow-down"></i></a>
                                    <!-- category submenu -->
                                    <ul class="category-mega-menu category-mega-menu-3">
                                        <li><a href="#">Wearable Devices</a></li>
                                        <li><a href="#">Smart Home Appliances</a></li>
                                        <li><a href="#">Smart Remote Controls</a></li>
                                        <li><a href="#">Smart Watches</a></li>
                                        <li><a href="#">Smart Wristbands</a></li>
                                    </ul>
                                </li>
                                <li class="menu-item-has-children menu-item-has-children-4">
                                    <a href="#">Audio & Video <i class="ion-ios-arrow-down"></i></a>
                                    <!-- category submenu -->
                                    <ul class="category-mega-menu category-mega-menu-4">
                                        <li><a href="#">Televisions</a></li>
                                        <li><a href="#">TV Receivers</a></li>
                                        <li><a href="#">Projectors</a></li>
                                        <li><a href="#">Audio Amplifier Boards</a></li>
                                        <li><a href="#">TV Sticks</a></li>
                                    </ul>
                                </li>
                                <li class="menu-item-has-children menu-item-has-children-5">
                                    <a href="#">Portable Audio & Video <i class="ion-ios-arrow-down"></i></a>
                                    <!-- category submenu -->
                                    <ul class="category-mega-menu category-mega-menu-5">
                                        <li><a href="#">Headphones</a></li>
                                        <li><a href="#">Speakers</a></li>
                                        <li><a href="#">MP3 Players</a></li>
                                        <li><a href="#">VR/AR Devices</a></li>
                                        <li><a href="#">Microphones</a></li>
                                    </ul>
                                </li>
                                <li class="menu-item-has-children menu-item-has-children-6">
                                    <a href="#">Video Game <i class="ion-ios-arrow-down"></i></a>
                                    <!-- category submenu -->
                                    <ul class="category-mega-menu category-mega-menu-6">
                                        <li><a href="#">Handheld Game Players</a></li>
                                        <li><a href="#">Game Controllers</a></li>
                                        <li><a href="#">Joysticks</a></li>
                                        <li><a href="#">Stickers</a></li>
                                    </ul>
                                </li>
                                <li><a href="#">Televisions</a></li>
                                <li><a href="#">Digital Cameras</a></li>
                                <li><a href="#">Headphones</a></li>
                                <li><a href="#">Wearable Devices</a></li>
                                <li><a href="#">Smart Watches</a></li>
                                <li><a href="#">Game Controllers</a></li>
                                <li><a href="#"> Smart Home Appliances</a></li>
                                <li class="hidden"><a href="#">Projectors</a></li>
                                <li>
                                    <a href="#" id="more-btn"><i class="ion-ios-plus-empty" aria-hidden="true"></i> More Categories</a>
                                </li>
                            </ul>
                        </nav>
                    </div>

                    <!--=======  End of category menu =======-->
                </div>
                <!-- Beauty Category -->
			</div>
		</div>
	</div>
</header>
			<!--Header section end-->
	<?php if(!(is_front_page()||is_product())){ ?>
		<!-- Breadcrumb Section Start -->
        <div class="breadcrumb-section section bg-image" data-bg="./assets/images/bg/bg-title-shop.jpg">
            <div class="container">
                <div class="row">
                    <div class="col">

                        <div class="breadcrumb-title text-center">
                            <h1><?php
						if ( is_product_category() ) {
							single_cat_title();
						}
	else if ( is_post_type_archive() ) {
		if ( is_search()){
		woocommerce_page_title();
	} else{
		post_type_archive_title();
		}
	}
	else if(is_archive()){
		the_archive_title();
	}
	else if(is_home()){
		single_post_title();
	}

						else{
							the_title();
						}
						?> </h1>
							<?php if ( is_search()||is_product_category()||is_product() ||is_shop() ) {
				  //woocommerce_breadcrumb();
			  }else{ ?>
            <?php breadcrumb_trail();
}
						?>
                        </div>

                    </div>
                </div>
            </div>
        </div>
        <!-- Breadcrumb Section End -->
		<?php } ?>
