<?php
add_theme_support( 'custom-logo' );

// Add default posts and comments RSS feed links to head.
add_theme_support( 'automatic-feed-links' );

add_theme_support( 'post-thumbnails' );

add_theme_support( 'title-tag' );

// Add theme support for selective refresh for widgets.
add_theme_support( 'customize-selective-refresh-widgets' );



/**
 * Load breadcrumb_trail File
 */
if (!function_exists('breadcrumb_trail')) {
   require get_stylesheet_directory() . '/library/breadcrumbs/breadcrumbs.php';
}
/**
register_menus - register menus
***/
function scorpio_register_menus() {
  register_nav_menus(
    array(
    	'header-menu' => __( 'Primary Left' ),
      'header-menu-right' => __( 'Primary Right' ),
    	'top-menu' => __( 'Toggle Menu' ),
    	//'footer-menu' => __( 'Footer Menu' )
     )

  );
}
add_action( 'init', 'scorpio_register_menus' );

function theme_scorpio_scripts() {
	//wp_enqueue_style( 'bootstrap', 'https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css' );
	wp_enqueue_style( 'fontawesome', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css' );
/*	wp_enqueue_style( 'owl', 'https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.carousel.min.css' );
	wp_enqueue_style( 'slick', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick.min.css' );
  wp_enqueue_style( 'animate', 'https://cdnjs.cloudflare.com/ajax/libs/animate.css/3.1.0/animate.min.css?ver=5.3.4' );
  wp_enqueue_style( 'magnificPopup', 'https://cdnjs.cloudflare.com/ajax/libs/magnific-popup.js/1.1.0/magnific-popup.min.css?ver=5.3.4' );
  wp_enqueue_style( 'slimselect', 'https://cdnjs.cloudflare.com/ajax/libs/slim-select/1.15.1/slimselect.min.css' );*/
	//wp_enqueue_style( 'iconfont', get_template_directory_uri() . '/assets/css/vendor/iconfont.min.css' );
  wp_enqueue_style( 'vendor', get_template_directory_uri() . '/assets/css/vendor/vendor.min.css', array(), null );
  wp_enqueue_style( 'plugins', get_template_directory_uri() . '/assets/css/plugins/plugins.min.css', array(), null );
  wp_enqueue_style( 'styles', get_template_directory_uri() . '/assets/css/style.min.css' );
	//wp_enqueue_style( 'responsive', get_template_directory_uri() . '/css/responsive.css' );
	wp_enqueue_style( 'style', get_template_directory_uri() . '/style.css' );
  //wp_enqueue_script('modernizr', get_template_directory_uri() . '/assets/js/vendor/modernizr-2.8.3.min.js', null, null, false );

	//wp_enqueue_script('Jquery', 'https://cdnjs.cloudflare.com/ajax/libs/jquery/2.2.2/jquery.min.js', null, null, true );
	//wp_enqueue_script('popper', 'https://cdnjs.cloudflare.com/ajax/libs/popper.js/2.4.4/umd/popper.min.js', null, null, true );
	//wp_enqueue_script('bootstrap', 'https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js', null, null, true );
	/*wp_enqueue_script('jqueryui', 'https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.min.js', null, null, true );
	wp_enqueue_script('owl', 'https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/owl.carousel.min.js', null, null, true );
	wp_enqueue_script('slick', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick.min.js', null, null, true );
  	wp_enqueue_script('appear', 'https://cdnjs.cloudflare.com/ajax/libs/jquery-appear/0.1/jquery.appear.min.js', null, null, true );
    	wp_enqueue_script('magnificPopup', 'https://cdnjs.cloudflare.com/ajax/libs/magnific-popup.js/1.1.0/jquery.magnific-popup.min.js', null, null, true );

	//wp_enqueue_script('isotope-layout', 'https://unpkg.com/isotope-layout@3/dist/isotope.pkgd.min.js', null, null, true );
	wp_enqueue_script('muuri', 'https://cdnjs.cloudflare.com/ajax/libs/muuri/0.5.4/muuri.min.js', null, null, true );
wp_enqueue_script('slimselect', 'https://cdnjs.cloudflare.com/ajax/libs/slim-select/1.15.1/slimselect.min.js', null, null, true );*/
	wp_enqueue_script('vendor', get_template_directory_uri() . '/assets/js/vendor/vendor.min.js', array(), null, true );
  wp_enqueue_script('plugins', get_template_directory_uri() . '/assets/js/plugins/plugins.min.js', array(), null, true );
	wp_enqueue_script('script', get_template_directory_uri() . '/assets/js/main.js', array(), null, true );
}
add_action( 'wp_enqueue_scripts', 'theme_scorpio_scripts' );

/****
widgets_init - register widgets
****/
function scorpio_widgets_init() {
	// main sidebar
	register_sidebar (array(
		'name'          => __('Sidebar','rm'),
		'id'            => "sidebar-widget-area",
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<div class="widget-title"><h3 class="widgettitle">',
		'after_title'   => '</h3></div>' )
		);
		// Newsletter widget area
	register_sidebar (array(
		'name'          => __('Shop page Widget Area','scorpio'),
		'id'            => "shop-widget-area",
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
    'before_title'  => '<h4 class="mb-3">',
		'after_title'   => '</h4>' )
		);
	// first footer widget area
	register_sidebar (array(
		'name'          => __('First Footer Widget Area','scorpio'),
		'id'            => "footer-first-widget-area",
		'before_widget' => '<div id="%1$s" class="widget footer-widget footer-widget links-widget footer-list mb-4 %2$s">',
		'after_widget'  => '</div>',
    'before_title'  => '<h3 class="mb-3 theme-blue-text">',
		'after_title'   => '</h3>' )
		);
	// second footer widget area
	register_sidebar (array(
		'name'          => __('Second Footer Widget Area','rm'),
		'id'            => "footer-second-widget-area",
		'before_widget' => '<div id="%1$s" class="widget footer-widget links-widget footer-list mb-4 %2$s">',
		'after_widget'  => '</div>',
    'before_title'  => '<h3 class="mb-3 theme-blue-text">',
		'after_title'   => '</h3>' )
		);
	// third footer widget area
	register_sidebar (array(
		'name'          => __('Third Footer Widget Area','rm'),
		'id'            => "footer-third-widget-area",
		'before_widget' => '<div id="%1$s" class="widget text-white footer-widget address mb-4 %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3 class="mb-3 theme-blue-text">',
		'after_title'   => '</h3>' )
		);
    // fourth footer widget area
  	register_sidebar (array(
  		'name'          => __('Fourth Footer Widget Area','rm'),
  		'id'            => "footer-fourth-widget-area",
  		'before_widget' => '<div id="%1$s" class="widget text-white footer-widget  about-widget mb-4 %2$s">',
  		'after_widget'  => '</div>',
  		'before_title'  => '<h3 class="mb-3 theme-blue-text">',
  		'after_title'   => '</h3>' )
  		);
}
add_action('init', 'scorpio_widgets_init');


function scorpio_sanitize_dropdown_pages( $page_id, $setting ) {
  // Ensure $input is an absolute integer.
  $page_id = absint( $page_id );
  // If $page_id is an ID of a published page, return it; otherwise, return the default.
  return ( 'publish' == get_post_status( $page_id ) ? $page_id : $setting->default );
}

function scorpio_customize_register( $wp_customize ) {
	require_once get_stylesheet_directory() . '/dropdown-category.php';

	//topbar section panel
	$wp_customize->add_panel( 'mytheme_top_sec', array(
	    'priority' => 100,
	    'capability' => 'edit_theme_options',
	    'theme_supports' => '',
	    'title' => __( 'Topbar Setting', 'mytheme' ),
	    'description' => __( 'Add setting of topbar.', 'mytheme' ),
	) );
	//contact detail section
	$wp_customize->add_section('mytheme_contact_section',array(
		'title'	=> __('Contact details','mytheme'),
		'description'=> __('This section will add contact details of the site.','mytheme'),
		'panel' => 'mytheme_top_sec',
	));
	//phone number
	$wp_customize->add_setting('mytheme_phone_num',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mytheme_phone_num',array(
		'label'	=> __('Phone Number','mytheme'),
		'section'=> 'mytheme_contact_section',
		'setting'=> 'mytheme_phone_num',
		'type'=> 'text'
	));
	//email
	$wp_customize->add_setting('mytheme_email_id',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mytheme_email_id',array(
		'label'	=> __('Email','mytheme'),
		'section'=> 'mytheme_contact_section',
		'setting'=> 'mytheme_email_id',
		'type'=> 'text'
	));
	//open hours
	$wp_customize->add_setting('mytheme_open_hours',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mytheme_open_hours',array(
		'label'	=> __('Open Time','mytheme'),
		'section'=> 'mytheme_contact_section',
		'setting'=> 'mytheme_open_hours',
		'type'=> 'text'
	));


	//social media section
	$wp_customize->add_section('mytheme_social_section',array(
		'title'	=> __('Social Media links','mytheme'),
		'description'=> __('This section will add social media links of the site.','mytheme'),
		'panel' => 'mytheme_top_sec',
	));

	//Facebook
	$wp_customize->add_setting('mytheme_facebook_link',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mytheme_facebook_link',array(
		'label'	=> __('Facebook','mytheme'),
		'section'=> 'mytheme_social_section',
		'setting'=> 'mytheme_facebook_link',
		'type'=> 'text'
	));
	//Twitter
	$wp_customize->add_setting('mytheme_twitter_link',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mytheme_twitter_link',array(
		'label'	=> __('Twitter','mytheme'),
		'section'=> 'mytheme_social_section',
		'setting'=> 'mytheme_twitter_link',
		'type'=> 'text'
	));
	//instagram
	$wp_customize->add_setting('mytheme_instagram_link',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mytheme_instagram_link',array(
		'label'	=> __('Instagram','mytheme'),
		'section'=> 'mytheme_social_section',
		'setting'=> 'mytheme_instagram_link',
		'type'=> 'text'
	));
	//pinterest
	$wp_customize->add_setting('mytheme_pinterest_link',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mytheme_pinterest_link',array(
		'label'	=> __('Pinterest','mytheme'),
		'section'=> 'mytheme_social_section',
		'setting'=> 'mytheme_pinterest_link',
		'type'=> 'text'
	));


	//theme section panel
	$wp_customize->add_panel( 'mytheme_home_sec', array(
	    'priority' => 100,
	    'capability' => 'edit_theme_options',
	    'theme_supports' => '',
	    'title' => __( 'Home Page Sections Setting', 'mytheme' ),
	    'description' => __( 'Add setting of home page sections.', 'mytheme' ),
	) );

	//Features section
	$wp_customize->add_section('mytheme_features_section1',array(
		'title'	=> __('Features','mytheme'),
		'description'=> __('This section will display Feature Content of the site.','mytheme'),
		'panel' => 'mytheme_home_sec',
	));

// Features section pages
	for ( $count = 1; $count <= 4; $count++ ) {

		$wp_customize->add_setting( 'mytheme_features1' . $count, array(
			'default'           => '',
			'sanitize_callback' => 'absint'
		));
		$wp_customize->add_control( 'mytheme_features1' . $count, array(
			'label'    => __( 'Select Feature page '. $count, 'mytheme' ),
			'section'  => 'mytheme_features_section1',
			'type'     => 'dropdown-pages'
		));
	}


	//home about section
	$wp_customize->add_section('mytheme_about_section',array(
		'title'	=> __('About Section','mytheme'),
		'description'=> __('This section will display Welcome Content of the site.','mytheme'),
		'panel' => 'mytheme_home_sec',
	));
//section title
	$wp_customize->add_setting('mytheme_about_section_title',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mytheme_about_section_title',array(
		'label'	=> __('Section Title','mytheme'),
		'section'=> 'mytheme_about_section',
		'setting'=> 'mytheme_about_section_title',
		'type'=> 'text'
	));
//section subtitle
	/* $wp_customize->add_setting('mytheme_about_section_subtitle',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mytheme_about_section_subtitle',array(
		'label'	=> __('Section Sub Title','mytheme'),
		'section'=> 'mytheme_about_section',
		'setting'=> 'mytheme_about_section_subtitle',
		'type'=> 'text'
	)); */
	//about section page
	$wp_customize->add_setting( 'mytheme_about', array(
			'default'           => '',
			'sanitize_callback' => 'scorpio_sanitize_dropdown_pages'
		));
		$wp_customize->add_control( 'mytheme_about', array(
			'label'    => __( 'Select About content Page', 'mytheme' ),
			'section'  => 'mytheme_about_section',
			'type'     => 'dropdown-pages'
		));


		//Services section
	$wp_customize->add_section('mytheme_features_section2',array(
		'title'	=> __('Services','mytheme'),
		'description'=> __('This section will display service Content of the site.','mytheme'),
		'panel' => 'mytheme_home_sec',
	));

// Services section pages
	for ( $count = 1; $count <= 10; $count++ ) {

		$wp_customize->add_setting( 'mytheme_features2' . $count, array(
			'default'           => '',
			'sanitize_callback' => 'absint'
		));
		$wp_customize->add_control( 'mytheme_features2' . $count, array(
			'label'    => __( 'Select service page '. $count, 'mytheme' ),
			'section'  => 'mytheme_features_section2',
			'type'     => 'dropdown-pages'
		));
	}

		//home testimonials section
	$wp_customize->add_section('mytheme_testimonials_section',array(
		'title'	=> __('Testimonials Section','mytheme'),
		'description'=> __('This section will display testimonials of the page.','mytheme'),
		'panel' => 'mytheme_home_sec',
	));
	//section title
	$wp_customize->add_setting('mytheme_testimonials_section_title',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mytheme_testimonials_section_title',array(
		'label'	=> __('Section Title','mytheme'),
		'section'=> 'mytheme_testimonials_section',
		'setting'=> 'mytheme_testimonials_section_title',
		'type'=> 'text'
	));
	//section sub-title
	$wp_customize->add_setting('mytheme_testimonials_section_subtitle',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mytheme_testimonials_section_subtitle',array(
		'label'	=> __('Section Sub-title','mytheme'),
		'section'=> 'mytheme_testimonials_section',
		'setting'=> 'mytheme_testimonials_section_subtitle',
		'type'=> 'text'
	));

	//home blogs section
	$wp_customize->add_section('mytheme_blogs_section',array(
		'title'	=> __('Blogs Section','mytheme'),
		'description'=> __('This section will display blogs of the page.','mytheme'),
		'panel' => 'mytheme_home_sec',
	));
	//section title
	$wp_customize->add_setting('mytheme_blogs_section_title',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mytheme_blogs_section_title',array(
		'label'	=> __('Section Title','mytheme'),
		'section'=> 'mytheme_blogs_section',
		'setting'=> 'mytheme_blogs_section_title',
		'type'=> 'text'
	));

	$wp_customize->add_setting( 'home_blogs_category', array(
		'default'           => 0,
		'sanitize_callback' => 'absint',
	) );
	$wp_customize->add_control( new My_Dropdown_Category_Control( $wp_customize, 'home_blogs_category', array(
		'section'=> 'mytheme_blogs_section',
		'label'         => esc_html__( 'Blogs posts category', 'mytheme' ),
		'description'   => esc_html__( 'Select the category that the blogs will show posts from. If no category is selected, the blogs will be disabled.'),
		// Uncomment to pass arguments to wp_dropdown_categories()
		//'dropdown_args' => array(
		//	'taxonomy' => 'post_tag',
		//),
	) ) );
}
//add_action('customize_register', 'mytheme_customize_register');


add_post_type_support( 'page', 'excerpt' );


//add_action( 'wp_footer', 'back_to_top' );
    function back_to_top() {
        echo '<a id="totop" href="#"><i class="fa fa-arrow-circle-up" aria-hidden="true" style="font-size: 40px; color: #7b7db1;"></i>
</a>';
    }
    //add_action( 'wp_head', 'back_to_top_style' );
    function back_to_top_style() {
        echo '<style type="text/css">
            #totop {
                position: fixed;
                right: 30px;
                bottom: 30px;
                display: none;
                outline: none;
            }

        </style>';
    }
    //add_action( 'wp_footer', 'custom_script' );
    function custom_script() {
        echo '<script type="text/javascript">
            jQuery(document).ready(function($){
                $(window).scroll(function () {
                    if ( $(this).scrollTop() > 300 )
                        $("#totop").fadeIn();
                    else
                        $("#totop").fadeOut();
                });

                $("#totop").click(function () {
                    $("body,html").animate({ scrollTop: 0 }, 800 );
                    return false;
                });
                $(".menu-item-has-children").addClass("dropdown");
                $(".trail-items").addClass("bread-crumb");
            });
        </script>';
    }
function mytheme_add_woocommerce_support() {

}

//add_action( 'after_setup_theme', 'mytheme_add_woocommerce_support' );
add_theme_support( 'woocommerce');
	add_theme_support( 'wc-product-gallery-zoom' );
add_theme_support( 'wc-product-gallery-lightbox' );
add_theme_support( 'wc-product-gallery-slider' );


    if ( ! function_exists( 'scorpio_shop_cart_total_item' ) ){
		 function scorpio_shop_cart_total_item(){
		   global $woocommerce;
		  ?>
      <a href="#offcanvas-cart" class="offcanvas-toggle">
                                    <span class="cart-count"><?php echo esc_html($woocommerce->cart->cart_contents_count); ?></span>
                                    <i class="fal fa-shopping-cart"></i>
                                </a>

		  <?php }
		}
if ( ! function_exists( 'scorpio_shop_cart_count_product' ) ){
		  function scorpio_shop_cart_count_product(){

		       scorpio_shop_cart_total_item();

		  }
		}
		//cart view function
		function scorpio_shop_menu_cart_view($cart_view){
			global $woocommerce;
		    $cart_view= scorpio_shop_cart_count_product();
		    return $cart_view;
		}
		add_action( 'scorpio_cart_count','scorpio_shop_menu_cart_view');

    //add_action( 'scorpio_cart_count','scorpio_shop_cart_total_item');

function scorpio_shop_woo_cart_product(){
global $woocommerce;
?>
<div id="scorpio-cart" class="scorpio-cart">
<div class="scorpio-quickcart-dropdown">
<?php
woocommerce_mini_cart();
?>
</div>
</div>
    <?php
}
//add_action( 'scorpio_shop_woo_cart', 'scorpio_shop_woo_cart_product' );
add_filter('woocommerce_add_to_cart_fragments', 'scorpio_shop_add_to_cart_dropdown_fragment');
function scorpio_shop_add_to_cart_dropdown_fragment( $fragments ){
   ob_start();
   ?>
   <div class="widget_shopping_cart_content">
       <?php woocommerce_mini_cart(); ?>

   </div>
   <?php $fragments['div.widget_shopping_cart_content'] = ob_get_clean();

   return $fragments;

}
add_filter('woocommerce_add_to_cart_fragments', 'woocommerce_add_to_cart_count_fragments');
function woocommerce_add_to_cart_count_fragments( $fragments ){
   global $woocommerce;
   $productadd       = wp_kses_data($woocommerce->cart->cart_contents_count);
   ob_start();
   ?>

   <span class="cart-count"><?php echo esc_html( $productadd); ?></span>

 <?php $fragments['span.cart-count'] = ob_get_clean();

   return $fragments;

}
//remove_action( 'woocommerce_widget_shopping_cart_total', 'woocommerce_widget_shopping_cart_subtotal', 10 );
add_action( 'woocommerce_widget_custom_shopping_cart_total', 'woocommerce_widget_custom_shopping_cart_subtotal', 10 );
function woocommerce_widget_custom_shopping_cart_subtotal() {
  ?>
  <div class="sub-total">
  <?php
		echo '<strong>' . esc_html__( 'Subtotal:', 'woocommerce' ) . '</strong> ' . '<span class="amount">'.WC()->cart->get_cart_subtotal().'</span>'; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
?>
</div>
<?php
  }
function scorpio_add_to_cart_loop_button(){
  global $product;
  ?>
  <a href="<?php echo esc_url( $product->add_to_cart_url() ); ?>" class="product-button hintT-top" data-hint="Add to Cart"><i class="fa fa-shopping-cart"></i></a>

<?php }
//add_action( 'scorpio_cart_loop','scorpio_add_to_cart_loop_button');

if ( ! function_exists( 'scorpio_woocommerce_template_loop_product_title' ) ) {

	/**
	 * Show the product title in the product loop. By default this is an H2.
	 */
	function scorpio_woocommerce_template_loop_product_title() {
    ?>
    <div class="d-flex justify-content-between align-items-center mb-2">
    <?php
		echo '<h3 class="' . esc_attr( apply_filters( 'woocommerce_product_loop_title_classes', 'woocommerce-loop-product__title mb-0 theme-blue-text title' ) ) . '">' . get_the_title() . '</h3>'; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
?>
<a href="#" class="product-tag bg-gray px-3 py-0">single</a>
</div>
<?php
  }
}
remove_action( 'woocommerce_shop_loop_item_title', 'woocommerce_template_loop_product_title', 10 );
add_action( 'woocommerce_shop_loop_item_title','scorpio_woocommerce_template_loop_product_title', 10);
remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_price', 10 );
add_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_price', 10 );
add_action( 'woocommerce_shop_loop_item_excerpt','scorpio_woocommerce_template_loop_product_excerpt', 10);
function scorpio_woocommerce_template_loop_product_excerpt() {
  ?>
  <p class="product-excerpt">
  <?php
  echo get_the_excerpt();
  ?>
</p>
  <?php
}
?>
