<?php
/**
 * The Header for our theme.
 *
 * Displays all of the <head> section and everything up till <div id="content-vw">
 *
 * @package VW Solar Energy
 */

?><!DOCTYPE html>

<html <?php language_attributes(); ?>>

<head>
  <meta charset="<?php bloginfo( 'charset' ); ?>">
  <meta name="viewport" content="width=device-width">
  <link rel="profile" href="<?php echo esc_url( __( 'http://gmpg.org/xfn/11', 'vw-solar-energy' ) ); ?>">
  <link href="https://stackpath.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet" integrity="sha384-wvfXpqpZZVQGK6TAh5PVlGOfQNHSoD2xbE+QkPxCAFlNEevoEH3Sl0sibVcOQVnN" crossorigin="anonymous">
  <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php wp_body_open(); ?>
<header>
    <div class="mobile-fix-option"></div>
    <div class="top-header top-header-inverse">
        <div class="custom-container">
            <div class="row">
				<div class="col-lg-8 col-md-12">
				<ul class="ct-details">
					<li><?php if(get_theme_mod('mytheme_phone_num') != ''){ ?>
								<i class="<?php echo esc_html(get_theme_mod('vw_solar_energy_phone_number_icon','fa fa-phone')); ?>"></i><span><?php echo esc_html(get_theme_mod('mytheme_phone_num',''));?></span>
							<?php }?></li>
							<li>
							<?php if(get_theme_mod('mytheme_email_id') != ''){ ?>
			        			<i class="<?php echo esc_html(get_theme_mod('vw_solar_energy_email_address_icon','fa fa-envelope-open')); ?>"></i><span><?php echo esc_html(get_theme_mod('mytheme_email_id',''));?></span>
			        		<?php }?>
							</li>
							<li>
							<?php if(get_theme_mod('mytheme_open_hours') != ''){ ?>
			        			<i class="<?php echo esc_html(get_theme_mod('vw_solar_energy_timing_icon','fa fa-clock-o')); ?>"></i><span><?php echo esc_html(get_theme_mod('mytheme_open_hours',''));?></span>
			        		<?php }?>
							</li>
				</ul>
					<!--div class="row">
			        	<div class="col-lg-3 col-md-3">
			        		<?php if(get_theme_mod('mytheme_phone_num') != ''){ ?>
								<i class="<?php echo esc_html(get_theme_mod('vw_solar_energy_phone_number_icon','fas fa-phone')); ?>"></i><span><?php echo esc_html(get_theme_mod('mytheme_phone_num',''));?></span>
							<?php }?>
						</div>
			        	<div class="col-lg-4 col-md-4">
			        		<?php if(get_theme_mod('mytheme_email_id') != ''){ ?>
			        			<i class="<?php echo esc_html(get_theme_mod('vw_solar_energy_email_address_icon','fas fa-envelope-open')); ?>"></i><span><?php echo esc_html(get_theme_mod('mytheme_email_id',''));?></span>
			        		<?php }?>
			        	</div>
			        	<div class="col-lg-5 col-md-5">
			        		<?php if(get_theme_mod('mytheme_open_hours') != ''){ ?>
			        			<i class="<?php echo esc_html(get_theme_mod('vw_solar_energy_timing_icon','far fa-clock')); ?>"></i><span><?php echo esc_html(get_theme_mod('mytheme_open_hours',''));?></span>
			        		<?php }?>
			        	</div>
			        </div-->
		        </div>
	        	<div class="col-lg-4 col-md-12">
	        		<?php //dynamic_sidebar('social-widget'); ?>
					<div class="top_social">
    <div class="socialbox">
              <a class="twitter" href="https://twitter.com/" target="_blank"><i class="fa fa-twitter align-middle" aria-hidden="true"></i></a>
                          <a class="facebook" href="https://www.facebook.com/" target="_blank"><i class="fa fa-facebook-f align-middle " aria-hidden="true"></i></a>
                    <a class="youtube" href="https://www.youtube.com/" target="_blank"><i class="fa fa-youtube align-middle" aria-hidden="true"></i></a>
                    <a class="pintrest" href="https://in.pinterest.com/" target="_blank"><i class="fa fa-pinterest-p align-middle " aria-hidden="true"></i></a>
                    <a class="linkedin" href="https://www.linkedin.com" target="_blank"><i class="fa fa-linkedin-in align-middle" aria-hidden="true"></i></a>
                          <a class="gplus" href="https://plus.google.com/" target="_blank"><i class="fa fa-google-plus-g align-middle" aria-hidden="true"></i></a>
                      </div>
  </div>
	        	</div>
	        </div>
        </div>
    </div>
    <div class="layout-header1">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="main-menu-block">
                        <div class="menu-left">
                            <div class="sm-nav-block">
                                <span class="sm-nav-btn"><i class="fa fa-bars"></i></span>
                                <ul class="nav-slide">
                                    <li>
                                        <div class="nav-sm-back">
                                            back <i class="fa fa-angle-right pl-2"></i>
                                        </div>
                                    </li>
                                    <li> <a href="#">foodgrains</a></li>
                                    <li> <a href="#">bakery</a></li>
                                    <li> <a href="#">beverage</a></li>
                                    <li> <a href="#">snacks</a></li>
                                    <li> <a href="#">kitchen</a></li>
                                    <li> <a href="#">beauty</a></li>
                                    <li> <a href="#">FRESH FRUIT</a></li>
                                    <li> <a href="#">banana</a></li>
                                    <li> <a href="#">kiwi</a></li>
                                    <li> <a href="#">mangosteen</a></li>
                                    <li> <a href="#">grape</a></li>
                                    <li> <a href="#">zucchini</a></li>
                                    <li class="mor-slide-open">
                                        <ul>
                                            <li> <a>drangon fruits</a></li>
                                            <li> <a href="#">kiwi</a></li>
                                            <li>  <a href="#">mangosteen</a></li>
                                            <li><a href="#">grape</a></li>
                                            <li> <a href="#">zucchini</a></li>
                                        </ul>
                                    </li>
                                    <li>
                                        <a class="mor-slide-click">
                                            mor category
                                            <i class="fa fa-angle-down pro-down" ></i>
                                            <i class="fa fa-angle-up pro-up" ></i>
                                        </a>
                                    </li>
                                </ul>
                            </div>
							<div class="logo">
                            <div class="brand-logo">
                                <?php if ( has_custom_logo() ): ?>
                         <?php the_custom_logo(); ?>
                    <?php else : ?>
                        <a class="site-title" href="<?php echo esc_url( home_url( '/' )); ?>"><?php esc_url(bloginfo('name')); ?></a>
                    <?php endif; ?>
                            </div>
							</div>
                        </div>
                        <div class="menu-right">
                            <div class="toggle-block">
                                <nav id="main-nav">
                                    <div class="toggle-nav"><i class="fa fa-bars sidebar-bar"></i></div>
									 <?php
                wp_nav_menu(array(
                'theme_location'    => 'header-menu',
                'container' => false,
        'items_wrap'      => '<ul id="main-menu" class="sm pixelstrap sm-horizontal %2$s">%3$s</ul>',
        'item_spacing'    => 'preserve',
        'depth'           => 0,
       // 'walker'          => new My_Walker_Nav_Menu(),
                ));
                ?>
                                </nav>
                            </div>
                            <div>
                                <div class="icon-nav">
                                    <!--ul>
                                        <li class="mobile-user onhover-dropdown" onclick="openAccount()"><a href="#"><i class="icon-user"></i></a>
                                        </li>
                                        <li class="mobile-wishlist" onclick="openWishlist()">
                                            <a href="#">
                                                <i class="icon-heart"></i>
                                                <div class="cart-item"><div>0 item<span>wishlist</span></div></div></a></li>
                                        <li class="mobile-search"><a href="#"><i class="icon-search"></i></a>
                                            <div class ="search-overlay">
                                                <div>
                                                    <span class="close-mobile-search">×</span>
                                                    <div class="overlay-content">
                                                        <div class="container">
                                                            <div class="row">
                                                                <div class="col-xl-12">
                                                                    <form>
                                                                        <div class="form-group"><input type="text" class="form-control" id="exampleInputPassword1" placeholder="Search a Product"></div>
                                                                        <button type="submit" class="btn btn-primary"><i class="fa fa-search"></i></button>
                                                                    </form>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div></li>
                                        <li class="mobile-setting mobile-setting-hover" onclick="openSetting()"><a href="#"><i class="icon-settings"></i></a>
                                        </li>
                                    </ul>
                                    <div class="cart-block mobile-cart cart-hover-div" onclick="openCart()">
                                        <a href="#"><span class="cart-product">0</span><i class="icon-shopping-cart"></i></a>
                                    </div-->
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</header>
<!--header end-->