<?php
/**
 * The Header for our theme.
 *
 * Displays all of the <head> section and everything up till <div id="content-vw">
 *
 * @package Scorpio Shri Parvathi Exports
 */

?><!DOCTYPE html>

<html <?php language_attributes(); ?>>

<head>
  <meta charset="<?php bloginfo( 'charset' ); ?>">
  <meta name="viewport" content="width=device-width">
  <?php wp_head(); ?>
   <link href="https://fonts.googleapis.com/css?family=Roboto:400,500,700&amp;v=1557448256624" rel="stylesheet">
</head>

<body <?php body_class(); ?> >

    <div id="site-wrap" class="site">
        <div id="header-wrap" class="is-clearfix">
        <header id="header" class="site-header">
          <div id="header-inner" class="site-header-inner container">
            <div class="level top">
              <div class="level-left">
                <div id="header-logo" class="site-logo ">
                  <div id="logo-inner" class="site-logo-inner">
                    <?php if ( has_custom_logo() ): ?>
                         <?php the_custom_logo(); ?>
                    <?php else : ?>
                        <a class="site-title" href="<?php echo esc_url( home_url( '/' )); ?>"><?php esc_url(bloginfo('name')); ?></a>
                    <?php endif; ?>
                  </div>
                  <!-- #logo-inner -->
                </div>
                <!-- #header-logo -->
              </div>
              <!-- .level-left -->
              <div class="level-right">
                <ul class="topbar-info main-header">
					<?php
                    $phone_num=get_theme_mod('mytheme_phone_num');
                    $email_id=get_theme_mod('mytheme_email_id');
                    $open_hour=get_theme_mod('mytheme_open_hours');
                     ?>
                  <li>
                      <span class="media">
                        <span class="media-left">
                          <span class="icon">
                            <i class="icon-clock"></i>
                          </span>
                        </span>
                        <span class="media-content">
                          <strong><?php echo $open_hour; ?></strong>
                          <br>Sunday - Closed </span>
                      </span>
                  </li>
                  <li>
                      <span class="media">
                        <span class="media-left">
                          <span class="icon">
                            <i class="icon-location-pin"></i>
                          </span>
                        </span>
                        <span class="media-content">
                          <strong>NEW NO.16, OLD NO.9, PONNIAMMAN KOIL STREET,</strong>
                          <br>BHARATHI NAGAR, SELAIYUR, CHENNAI - 600 073. </span>
                      </span>
                  </li>
                  <li>
                      <span class="media">
                        <span class="media-left">
                          <span class="icon">
                            <i class="icon-screen-smartphone"></i>
                          </span>
                        </span>
                        <span class="media-content">
							<strong><a href="tel:<?php echo $phone_num; ?>"><?php echo $phone_num; ?></a></strong>
							<br><a href="mailto:<?php echo $email_id; ?>"><?php echo $email_id; ?></a></span>
                      </span>
                  </li>
                </ul>
              </div>
              <!-- .level-right -->
            </div>
            <!-- .level.top -->
            <div class="level">
              <div class="level-left">
                        <?php
                wp_nav_menu(array(
                'theme_location'    => 'header-menu',
                ));
                ?>
              </div>
              <!-- .level-left -->
              <div class="level-right">
                <ul class="header-menu-icons social">
					<?php
                    $fb=get_theme_mod('mytheme_facebook_link');
                    $tr=get_theme_mod('mytheme_twitter_link');
                    $ins=get_theme_mod('mytheme_instagram_link');
                    $pin=get_theme_mod('mytheme_pinterest_link');
                     ?>
					<?php if($fb!=''){ ?>
                  <li>					   
                    <a href="<?php echo $fb; ?>" target="_blank">
                      <span class="icon">
                        <i class="fab fa-facebook-f"></i>
                      </span>
                    </a>
                  </li>
					 <?php } 
                    if($tr!=''){ ?>
                  <li>
                    <a href="<?php echo $tr; ?>" target="_blank">
                      <span class="icon">
                        <i class="fab fa-twitter"></i>
                      </span>
                    </a>
                  </li>
					<?php } 
                    if($ins!=''){
                        ?>					
                  <li>
                    <a href="<?php echo $ins; ?>" target="_blank">
                      <span class="icon">
                        <i class="fab fa-instagram"></i>
                      </span>
                    </a>
                  </li>
					<?php } 
                    if($pin!=''){
                        ?>
                  <li>
                    <a href="<?php echo $pin; ?>" target="_blank">
                      <span class="icon">
                        <i class="fab fa-linkedin-in"></i>
                      </span>
                    </a>
                  </li>
					 <?php } ?>
                </ul>
                <!-- .header-menu-icons -->
                <ul class="header-menu-icons ">
                  <li class="dropdown-search-form search-style-2">
                    <a href="javascript:void(0);">
                      <span class="icon">
                        <i class="icon-magnifier"></i>
                      </span>
                    </a>
                    <ul>
                      <li class="header widget-form">
                        <form>
                          <div class="field">
                            <div class="control is-expanded">
                              <input class="input" type="text" placeholder="Search...">
                              <button type="submit" class="button">
                                <span class="icon">
                                  <i class="icon-magnifier"></i>
                                </span>
                              </button>
                            </div>
                          </div>
                        </form>
                      </li>
                    </ul>
                  </li>
                  <!--li class="show-quickview">
                    <a href="javascript:void(0);" data-show="quickview" data-target="quickviewInfo">
                      <span class="icon">
                        <i class="ion-ios-menu"></i>
                      </span>
                    </a>
                  </li-->
                </ul>
                <!-- .header-menu-icons -->
                <div class="modal search-form-overlay">
                  <div class="modal-background"></div>
                  <div class="modal-content">
                    <form class="widget-form">
                      <div class="field">
                        <div class="control is-expanded">
                          <input class="input" type="text" placeholder="Search...">
                          <button type="submit" class="button">
                            <span class="icon">
                              <i class="icon-magnifier"></i>
                            </span>
                          </button>
                        </div>
                      </div>
                    </form>
                  </div>
                  <button class="modal-close is-large" aria-label="close"></button>
                </div>
                <!-- .modal.search-form-overlay -->
                <div id="quickviewInfo" class="quickview">
                  <div class="quickview-header">
                    <p class="title"></p>
                    <span class="delete" data-dismiss="quickview"></span>
                  </div>
                  <div class="quickview-body">
                    <div class="quickview-block">
                      <div class="footer">
                        <div class="columns is-variable is-multiline">
                          <div class="column is-12">
                            <div class="widget widget-html">
                              <div class="textwidget">
                                <div id="footer-logo" class="site-logo ">
                                  <a href="index-2.html">
                                    <span class="logo-text">Logistics</span>
                                  </a>
                                </div>
                                <!-- #footer-logo -->
                                <p>The main component of a healthy environment for self esteem is that it needs be nurturing.</p>
                                <div class="footer-social-links ">
                                  <ul>
                                    <li>
                                      <a href="#" target="_blank">
                                        <span class="icon">
                                          <i class="fab fa-facebook-f"></i>
                                        </span>
                                      </a>
                                    </li>
                                    <li>
                                      <a href="#" target="_blank">
                                        <span class="icon">
                                          <i class="fab fa-twitter"></i>
                                        </span>
                                      </a>
                                    </li>
                                    <li>
                                      <a href="#" target="_blank">
                                        <span class="icon">
                                          <i class="fab fa-instagram"></i>
                                        </span>
                                      </a>
                                    </li>
                                    <li>
                                      <a href="#" target="_blank">
                                        <span class="icon">
                                          <i class="fab fa-pinterest-p"></i>
                                        </span>
                                      </a>
                                    </li>
                                  </ul>
                                </div>
                              </div>
                              <!-- .textwidget -->
                            </div>
                          </div>
                          <!-- .column -->
                          <div class="column is-12">
                            <img alt="Joo - Niche Multi-Purpose HTML Template" src="assets/images/global/introduction-3.png"> </div>
                          <!-- .column -->
                          <div class="column is-12">
                            <div class="widget widget-form">
                              <h3 class="widget-title ">subscribe</h3>
                              <p>The main component of a healthy environment.</p>
                              <br>
                              <form>
                                <div class="field">
                                  <div class="control is-expanded">
                                    <input class="input" type="text" placeholder="your@email.com">
                                    <button type="submit" class="button is-radiusless">
                                      <span class="icon">
                                        <i class="ion-ios-arrow-round-forward-outline"></i>
                                      </span>
                                    </button>
                                  </div>
                                </div>
                              </form>
                            </div>
                          </div>
                          <!-- .column -->
                        </div>
                        <!-- .columns -->
                      </div>
                      <!-- .footer -->
                    </div>
                  </div>
                </div>
              </div>
              <!-- .level-right -->
            </div>
            <!-- .level -->
          </div>
          <!-- #header-inner -->
        </header>
        <!-- #header -->
      </div>
      <!-- #header-wrap -->
		<?php if(!(is_front_page())){ ?>
		<!-- #header-wrap -->
      <div class="inner-page-titlecontainer" style="background:url(<?php echo get_site_url(); ?>/wp-content/uploads/2020/03/sub_banner.jpg); background-size:cover;">
          <?php if ( is_search()||is_product_category()||is_product() ||is_shop() ) {
				  woocommerce_breadcrumb();
			  }else{ ?>
            <?php breadcrumb_trail();
}
						?>
						<?php
						if ( is_product_category() ) {
							?> <h1 class="title" data-aos="fade-up"><?php single_cat_title(); ?></h1> <?php
						}
						else if ( is_post_type_archive() ) {
		if ( is_search()){
		 ?> <h1 class="title" data-aos="fade-up"><?php woocommerce_page_title(); ?></h1> <?php
	} else{
		 ?> <h1 class="title" data-aos="fade-up"><?php post_type_archive_title(); ?></h1> <?php
		}
	}
	else if(is_archive()){
		?> <h1 class="title" data-aos="fade-up"><?php the_archive_title('',false) ?></h1> <?php
	}
						
	else if(is_home()){
		?> <h1 class="title" data-aos="fade-up"><?php single_post_title(); ?></h1> <?php
	}
	else{
							?> <h1 class="title" data-aos="fade-up"><?php the_title(); ?></h1> <?php
						} ?>
                  
                 
					<!--div class="heading-title-top" data-aos="fade"><?php breadcrumb_trail(); ?></div-->
                </div>
      <!-- #header-bottom-wrap -->     
        <div class="content-container">
<div class="container">
<?php } ?>