<?php

defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'wp_image_zoooom_settings' ) ) {
	function wp_image_zoooom_settings() {

		$settings = array(
			'lensShape'                  => array(
				'label'      => __( 'Lens Shape', 'wp-image-zoooom' ),
				'values'     => array(
					'none'        => array( '<i class="icon-lens_shape_none"></i>', __( 'No Lens', 'wp-image-zoooom' ) ),
					'round'       => array( '<i class="icon-lens_shape_circle"></i>', __( 'Circle Lens', 'wp-image-zoooom' ) ),
					'square'      => array( '<i class="icon-lens_shape_square"></i>', __( 'Square Lens', 'wp-image-zoooom' ) ),
					'zoom_window' => array( '<i class="icon-type_zoom_window"></i>', __( 'With Zoom Window', 'wp-image-zoooom' ) ),
				),
				'value'      => 'zoom_window',
				'input_form' => 'buttons',
				'style'      => 'full',
				'no_wrap'    => true,
				'section'    => 'settings',
			),
			'cursorType'                 => array(
				'label'      => __( 'Cursor Type', 'wp-image-zoooom' ),
				'values'     => array(
					'default'   => array( '<i class="icon-cursor_type_default"></i>', __( 'Default', 'wp-image-zoooom' ) ),
					'pointer'   => array( '<i class="icon-cursor_type_pointer"></i>', __( 'Pointer', 'wp-image-zoooom' ) ),
					'crosshair' => array( '<i class="icon-cursor_type_crosshair"></i>', __( 'Crosshair', 'wp-image-zoooom' ) ),
					'zoom-in'   => array( '<i class="icon-zoom-in"></i>', __( 'Zoom', 'wp-image-zoooom' ) ),
				),
				'value'      => 'default',
				'input_form' => 'buttons',
				'style'      => 'full',
				'section'    => 'settings',
			),
			'zwEasing'                   => array(
				'label'       => __( 'Animation Easing Effect', 'wp-image-zoooom' ),
				'value'       => 12,
				'description' => __( 'A number between 0 and 200 to represent the degree of the Animation Easing Effect', 'wp-image-zoooom' ),
				'input_form'  => 'input_text',
				'validate'    => array(
					'type'  => 'int',
					'range' => array( 0, 200 ),
				),
				'section'     => 'settings',
			),
			'onClick'                    => array(
				'label'      => __( 'Enable the zoom on ...', 'wp-image-zoooom' ),
				'values'     => array(
					'false' => __( 'mouse hover', 'wp-image-zoooom' ),
					'true'  => __( 'mouse click', 'wp-image-zoooom' ),
				),
				'value'      => 'false',
				'input_form' => 'radio',
				'pro'        => true,
				'section'    => 'settings',
			),
			'ratio'                      => array(
				'label'       => __( 'Zoom Level', 'wp-image-zoooom' ),
				'values'      => array(
					'default' => array( '<i class="icon-zoom_level_default"></i>', __( 'Default', 'wp-image-zoooom' ) ),
					'1.5'     => array( '<i class="icon-zoom_level_15"></i>', __( '1,5 times', 'wp-image-zoooom' ) ),
					'2'       => array( '<i class="icon-zoom_level_2"></i>', __( '2 times', 'wp-image-zoooom' ) ),
					'2.5'     => array( '<i class="icon-zoom_level_25"></i>', __( '2,5 times', 'wp-image-zoooom' ) ),
					'3'       => array( '<i class="icon-zoom_level_3"></i>', __( '3 times', 'wp-image-zoooom' ) ),
				),
				'value'       => 'default',
				'description' => __( 'By default the zoom level is calculated automatically from the full size of the uploaded image', 'wp-image-zoooom' ),
				'input_form'  => 'buttons',
				'pro'         => true,
				'style'       => 'full',
				'section'     => 'settings',
			),
			'lensSize'                   => array(
				'label'       => __( 'Lens Size', 'wp-image-zoooom' ),
				'post_input'  => 'px',
				'value'       => 200,
				'description' => __( 'For Circle Lens it means the diameters, for Square Lens it means the width', 'wp-image-zoooom' ),
				'input_form'  => 'input_text',
				'validate'    => array(
					'type'  => 'int',
					'range' => array( 20, 2000 ),
				),
				'section'     => 'settings',
			),
			'lensColour'                 => array(
				'label'       => __( 'Lens Color', 'wp-image-zoooom' ),
				'value'       => '#ffffff',
				'pro'         => true,
				'input_form'  => 'input_color',
				'description' => __( 'Only for Zoom Window. Only when Tint is not used', 'wp-image-zoooom' ),
				'section'     => 'settings',
			),
			'lensOverlay'                => array(
				'label'       => __( 'Show as Grid', 'wp-image-zoooom' ),
				'value'       => false,
				'pro'         => true,
				'input_form'  => 'checkbox',
				'description' => __( 'Only for Zoom Window. Only when Tint is not used', 'wp-image-zoooom' ),
				'section'     => 'settings',
			),
			'borderThickness'            => array(
				'label'      => __( 'Border Thickness', 'wp-image-zoooom' ),
				'post_input' => 'px',
				'value'      => 1,
				'input_form' => 'input_text',
				'validate'   => array(
					'type'  => 'int',
					'range' => array( 0, 200 ),
				),
				'section'    => 'settings',
			),
			'borderColor'                => array(
				'label'      => __( 'Border Color', 'wp-image-zoooom' ),
				'value'      => '#ffffff',
				'input_form' => 'input_color',
				'section'    => 'settings',
			),
			'lensFade'                   => array(
				'label'       => __( 'Fade Time', 'wp-image-zoooom' ),
				'post_input'  => 'sec',
				'value'       => 0.5,
				'description' => __( 'The amount of time it takes for the Lens to slowly appear or disappear', 'wp-image-zoooom' ),
				'input_form'  => 'input_text',
				'validate'    => array(
					'type'  => 'float',
					'range' => array( 0, 10 ),
				),
				'section'     => 'settings',
			),
			'tint'                       => array(
				'label'       => __( 'Tint', 'wp-image-zoooom' ),
				'value'       => true,
				'description' => __( 'A color that will layed on top the of non-magnified image in order to emphasize the lens', 'wp-image-zoooom' ),
				'input_form'  => 'checkbox',
				'section'     => 'settings',
			),
			'tintColor'                  => array(
				'label'      => __( 'Tint Color', 'wp-image-zoooom' ),
				'value'      => '#ffffff',
				'input_form' => 'input_color',
				'section'    => 'settings',
			),
			'tintOpacity'                => array(
				'label'       => __( 'Tint Opacity', 'wp-image-zoooom' ),
				'value'       => '0.1',
				'post_input'  => '%',
				'input_form'  => 'input_text',
				'description' => __( 'Accepted value between 0 and 1', 'wp-image-zoooom' ),
				'validate'    => array(
					'type'  => 'float',
					'range' => array( 0, 1 ),
				),
				'section'     => 'settings',
			),
			'zwWidth'                    => array(
				'label'      => __( 'Zoom Window Width', 'wp-image-zoooom' ),
				'post_input' => 'px',
				'value'      => 400,
				'input_form' => 'input_text',
				'validate'   => array(
					'type'  => 'int',
					'range' => array( 0, 2000 ),
				),
				'section'    => 'settings',
			),
			'zwHeight'                   => array(
				'label'      => __( 'Zoom Window Height', 'wp-image-zoooom' ),
				'post_input' => 'px',
				'value'      => 360,
				'input_form' => 'input_text',
				'validate'   => array(
					'type'  => 'int',
					'range' => array( 0, 2000 ),
				),
				'section'    => 'settings',
			),
			'zwResponsive'               => array(
				'label'       => __( 'Responsive', 'wp-image-zoooom' ),
				'description' => __( 'The Zoom Window Width will adapt to the browser\'s size. Works only on the frontend, not on this demo.', 'wp-image-zoooom' ),
				'input_form'  => 'checkbox',
				'value'       => true,
				'pro'         => true,
				'section'     => 'settings',
			),
			'zwResponsiveThreshold'      => array(
				'label'       => __( 'Responsive Threshold', 'wp-image-zoooom' ),
				'description' => __( 'The zoom type will authomatically switch to No Lens zoom once the browser\'s width becomes less than the threshold. Works only on the frontend, not on this demo.', 'wp-image-zoooom' ),
				'post_input'  => 'px',
				'value'       => 800,
				'input_form'  => 'input_text',
				'validate'    => array(
					'type'  => 'int',
					'range' => array( 1, 3000 ),
				),
				'pro'         => true,
				'section'     => 'settings',
			),
			'zwPositioning'              => array(
				'label'       => __( 'Positioning', 'wp-image-zoooom' ),
				'values'      => array(
					'right_top'    => array( '<i class="icon-type_zoom_window_right_top"></i>', __( 'Right Top', 'wp-image-zoooom' ) ),
					'right_bottom' => array( '<i class="icon-type_zoom_window_right_bottom"></i>', __( 'Right Bottom', 'wp-image-zoooom' ) ),
					'right_center' => array( '<i class="icon-type_zoom_window_right_center"></i>', __( 'Right Center', 'wp-image-zoooom' ) ),
					'left_top'     => array( '<i class="icon-type_zoom_window_left_top"></i>', __( 'Left Top', 'wp-image-zoooom' ) ),
					'left_bottom'  => array( '<i class="icon-type_zoom_window_left_bottom"></i>', __( 'Left Bottom', 'wp-image-zoooom' ) ),
					'left_center'  => array( '<i class="icon-type_zoom_window_left_center"></i>', __( 'Left Center', 'wp-image-zoooom' ) ),
				),
				'value'       => 'right_top',
				'description' => __( 'Feature available only in the PRO Version', 'wp-image-zoooom' ),
				'disabled'    => true,
				'input_form'  => 'buttons',
				'style'       => 'full',
				'pro'         => true,
				'section'     => 'settings',
			),
			'zwPadding'                  => array(
				'label'      => __( 'Distance from the Main Image', 'wp-image-zoooom' ),
				'post_input' => 'px',
				'value'      => 10,
				'input_form' => 'input_text',
				'validate'   => array(
					'type'  => 'int',
					'range' => array( 0, 200 ),
				),
				'section'    => 'settings',
			),
			'zwBorderThickness'          => array(
				'label'      => __( 'Border Thickness', 'wp-image-zoooom' ),
				'post_input' => 'px',
				'value'      => 1,
				'input_form' => 'input_text',
				'validate'   => array(
					'type'  => 'int',
					'range' => array( 0, 200 ),
				),
				'section'    => 'settings',
			),
			'zwShadow'                   => array(
				'label'       => __( 'Shadow Thickness', 'wp-image-zoooom' ),
				'post_input'  => 'px',
				'value'       => 4,
				'input_form'  => 'input_text',
				'description' => __( 'Use 0px to remove the shadow', 'wp-image-zoooom' ),
				'validate'    => array(
					'type'  => 'int',
					'range' => array( 0, 500 ),
				),
				'section'     => 'settings',
			),
			'zwBorderColor'              => array(
				'label'      => __( 'Border Color', 'wp-image-zoooom' ),
				'value'      => '#888888',
				'input_form' => 'input_color',
				'section'    => 'settings',
			),
			'zwBorderRadius'             => array(
				'label'      => __( 'Rounded Corners', 'wp-image-zoooom' ),
				'post_input' => 'px',
				'value'      => 0,
				'input_form' => 'input_text',
				'validate'   => array(
					'type'  => 'int',
					'range' => array( 0, 500 ),
				),
				'section'    => 'settings',
			),
			'mousewheelZoom'             => array(
				'label'       => __( 'Mousewheel Zoom', 'wp-image-zoooom' ),
				'value'       => true,
				'description' => __( 'When using the mousewheel, the zoomed level of the image will change', 'wp-image-zoooom' ),
				'input_form'  => 'checkbox',
				'pro'         => true,
				'section'     => 'settings',
			),
			'zwVerticallyResponsive'     => array(
				'label'       => __( 'Zoom Window vertically responsive', 'wp-image-zoooom' ),
				'value'       => false,
				'description' => __( 'If the Mousewheel Zoom option is enabled, then the user cannot scroll the page. This option will adjust the Zoom Window\'s position vertically so it can always be fully visible.', 'wp-image-zoooom' ),
				'input_form'  => 'checkbox',
				'section'     => 'settings',
			),
			'zwFade'                     => array(
				'label'       => __( 'Fade Time', 'wp-image-zoooom' ),
				'post_input'  => 'sec',
				'value'       => 0.5,
				'description' => __( 'The amount of time it takes for the Zoom Window to slowly appear or disappear', 'wp-image-zoooom' ),
				'input_form'  => 'input_text',
				'validate'    => array(
					'type'  => 'float',
					'range' => array( 0, 10 ),
				),
				'section'     => 'settings',
			),
			'customText'                 => array(
				'label'       => __( 'Text on the image', 'wp-image-zoooom' ),
				'value'       => '',
				'description' => __( 'Feature available only in the PRO Version', 'wp-image-zoooom' ),
				'input_form'  => 'input_text',
				'disabled'    => true,
				'section'     => 'settings',
			),
			'customTextSize'             => array(
				'label'       => __( 'Text Size', 'wp-image-zoooom' ),
				'post_input'  => 'px',
				'value'       => 12,
				'description' => __( 'Feature available only in the PRO Version', 'wp-image-zoooom' ),
				'input_form'  => 'input_text',
				'disabled'    => true,
				'validate'    => array(
					'type'  => 'int',
					'range' => array( 0, 45 ),
				),
				'section'     => 'settings',
			),
			'customTextColor'            => array(
				'label'       => __( 'Text Color', 'wp-image-zoooom' ),
				'value'       => '#cccccc',
				'description' => __( 'Feature available only in the PRO Version', 'wp-image-zoooom' ),
				'input_form'  => 'input_color',
				'disabled'    => true,
				'section'     => 'settings',
			),
			'customTextAlign'            => array(
				'label'      => __( 'Text Align', 'wp-image-zoooom' ),
				'values'     => array(
					'top_left'      => array( '<i class="icon-text_align_top_left"></i>', __( 'Top Left', 'wp-image-zoooom' ) ),
					'top_center'    => array( '<i class="icon-text_align_top_center"></i>', __( 'Top Center', 'wp-image-zoooom' ) ),
					'top_right'     => array( '<i class="icon-text_align_top_right"></i>', __( 'Top Right', 'wp-image-zoooom' ) ),
					'bottom_left'   => array( '<i class="icon-text_align_bottom_left"></i>', __( 'Bottom Left', 'wp-image-zoooom' ) ),
					'bottom_center' => array( '<i class="icon-text_align_bottom_center"></i>', __( 'Bottom Center', 'wp-image-zoooom' ) ),
					'bottom_right'  => array( '<i class="icon-text_align_bottom_right"></i>', __( 'Bottom Right', 'wp-image-zoooom' ) ),
				),
				'value'      => 'bottom_right',
				'input_form' => 'buttons',
				'style'      => 'full',
				'section'    => 'settings',
			),
			'enable_woocommerce'         => array(
				'label'      => __( 'Enable the zoom on WooCommerce products', 'wp-image-zoooom' ),
				'value'      => true,
				'input_form' => 'checkbox',
				'section'    => 'general',
			),
			'exchange_thumbnails'        => array(
				'label'       => __( 'Exchange the thumbnail with main image on WooCommerce products', 'wp-image-zoooom' ),
				'value'       => true,
				'input_form'  => 'checkbox',
				'description' => __( 'On a WooCommerce gallery, when clicking on a thumbnail, not only the main image will be replaced with the thumbnail\'s image, but also the thumbnail will be replaced with the main image', 'wp-image-zoooom' ),
				'section'     => 'general',
			),
			'enable_mobile'              => array(
				'label'       => __( 'Enable the zoom on mobile devices', 'wp-image-zoooom' ),
				'value'       => false,
				'input_form'  => 'checkbox',
				'description' => __( 'Tablets are also considered mobile devices', 'wp-image-zoooom' ),
				'section'     => 'general',
			),
			'woo_variations'             => array(
				'label'      => __( 'Enable on WooCommerce variation products', 'wp-image-zoooom' ),
				'value'      => false,
				'input_form' => 'checkbox',
				'pro'        => true,
				'section'    => 'general',
			),
			'woo_cat'                    => array(
				'label'      => __( 'Enable the zoom on WooCommerce category pages', 'wp-image-zoooom' ),
				'value'      => false,
				'input_form' => 'checkbox',
				'section'    => 'general',
			),
			'force_woocommerce'          => array(
				'label'      => __( 'Force it to work on WooCommerce', 'wp-image-zoooom' ),
				'value'      => true,
				'input_form' => 'checkbox',
				'section'    => 'general',
			),
			'remove_lightbox_thumbnails' => array(
				'label'       => __( 'Remove the Lightbox on thumbnail images', 'wp-image-zoooom' ),
				'value'       => true,
				'input_form'  => 'checkbox',
				'description' => __( 'Some themes implement a Lightbox for WooCommerce galleris that opens on click. Enabling this checkbox will remove the Lightbox on thumbnail images and leave it only on the main image', 'wp-image-zoooom' ),
				'pro'         => true,
				'section'     => 'general',
			),
			'remove_lightbox'            => array(
				'label'       => __( 'Remove the Lightbox', 'wp-image-zoooom' ),
				'value'       => true,
				'input_form'  => 'checkbox',
				'description' => __( 'Some themes implement a Lightbox that opens on click on the image. Enabling this checkbox will remove the Lightbox' ),
				'pro'         => true,
				'section'     => 'general',
			),

			'force_attachments'          => array(
				'label'      => __( 'Enable on attachments pages', 'wp-image-zoooom' ),
				'value'      => false,
				'input_form' => 'checkbox',
				'pro'        => true,
				'section'    => 'general',
			),
			'custom_class'               => array(
				'label'       => __( 'Apply zoom on this particular image(s)', 'wp-image-zoooom' ),
				'value'       => '',
				'input_form'  => 'input_text',
				'description' => __( 'CSS style selector(s) for identifying the image(s) on which to apply the zoom.', 'wp-image-zoooom' ),
				'pro'         => true,
				'section'     => 'general',
			),
			'flexslider'                 => array(
				'label'       => __( 'FlexSlider container class', 'wp-image-zoooom' ),
				'value'       => '',
				'input_form'  => 'input_text',
				'description' => __( 'If the images are in a Woo FlexSlider gallery, then type in here the class of the div containing the FlexSlider gallery', 'wp-image-zoooom' ),
				'pro'         => true,
				'section'     => 'general',
			),
			'owl'                        => array(
				'label'       => __( '<a href="https://owlcarousel2.github.io/OwlCarousel2/" target="_blank">Owl Carousel</a> container class', 'wp-image-zoooom' ),
				'value'       => '',
				'input_form'  => 'input_text',
				'description' => __( 'If the images are in a Owl Carousel gallery, then type in here the class of the div containing the Owl Carousel gallery', 'wp-image-zoooom' ),
				'pro'         => true,
				'section'     => 'general',
			),
			'flickity'                   => array(
				'label'       => __( '<a href="https://flickity.metafizzy.co/" target="_blank">Flickity Carousel</a> container class', 'wp-image-zoooom' ),
				'value'       => '',
				'input_form'  => 'input_text',
				'description' => __( 'If the images are in a Flickity Carousel gallery, then type in here the class of the div containing the Flickity Carousel gallery', 'wp-image-zoooom' ),
				'pro'         => true,
				'section'     => 'general',
			),
			'swiper'                     => array(
				'label'       => __( '<a href="http://idangero.us/swiper/" target="_blank">Swiper slider</a> container class', 'wp-image-zoooom' ),
				'value'       => '',
				'input_form'  => 'input_text',
				'description' => __( 'If the images are in a Swiper slider, then type in here the class of the div containing the Swiper slider', 'wp-image-zoooom' ),
				'pro'         => true,
				'section'     => 'general',
			),
			'slick'                      => array(
				'label'       => __( '<a href="https://kenwheeler.github.io/slick/" target="_blank">Slick carousel</a> container class', 'wp-image-zoooom' ),
				'value'       => '',
				'input_form'  => 'input_text',
				'description' => __( 'If the images are in a Slick carousel gallery, then type in here the class of the div containing the Slick carousel gallery', 'wp-image-zoooom' ),
				'pro'         => true,
				'section'     => 'general',
			),
			'huge_it_gallery'            => array(
				'label'       => __( '<a href="https://wordpress.org/plugins/gallery-images/" target="_blank">Huge IT Gallery</a> id', 'wp-image-zoooom' ),
				'value'       => '',
				'input_form'  => 'input_text',
				'description' => __( 'In order to apply to more galleries, enter the respective ids separated by comma', 'wp-image-zoooom' ),
				'pro'         => true,
				'section'     => 'general',
			),
			'enable_lightbox_zoom'       => array(
				'label'      => __( 'Enable inside a Lightbox. <a href="#TB_inline?width=600&height=400&inlineId=supported-lightboxes" class="thickbox">See supported lightboxes</a>', 'wp-image-zoooom' ),
				'value'      => false,
				'input_form' => 'checkbox',
				'pro'         => true,
				'section'    => 'general',
			),
			'image_title_position'       => array(
				'label'      => __( 'Image Title Position on the Zoom Window', 'wp-image-zoooom' ),
				'values'     => array(
					'false'  => __( 'Do no show', 'wp-image-zoooom' ),
					'top'    => __( 'Top', 'wp-image-zoooom' ),
					'bottom' => __( 'Bottom', 'wp-image-zoooom' ),
				),
				'value'      => 'false',
				'input_form' => 'radio',
				'pro'        => true,
				'section'    => 'settings',
			),
			'image_title_color'          => array(
				'label'      => __( 'Image Title Text Color', 'wp-image-zoooom' ),
				'value'      => '#ffffff',
				'input_form' => 'input_color',
				'pro'        => true,
				'section'    => 'settings',
			),
			'image_title_bg'             => array(
				'label'      => __( 'Image Title Background Color', 'wp-image-zoooom' ),
				'value'      => '#000000',
				'input_form' => 'input_color',
				'pro'        => true,
				'section'    => 'settings',
			),
			'image_title_size'           => array(
				'label'      => __( 'Image Title Font Size', 'wp-image-zoooom' ),
				'post_input' => 'px',
				'value'      => 12,
				'input_form' => 'input_text',
				'pro'        => true,
				'validate'   => array(
					'type'  => 'int',
					'range' => array( 0, 45 ),
				),
				'section'    => 'settings',
			),
			'lens_overflow'              => array(
				'label'      => __( 'Lens margins extend over image\'s margins', 'wp-image-zoooom' ),
				'value'      => false,
				'input_form' => 'checkbox',
				'section'    => 'settings',
			),

		);

		return $settings;
	}
}
