<?php
add_theme_support( 'custom-logo' );

// Add default posts and comments RSS feed links to head.
add_theme_support( 'automatic-feed-links' );

add_theme_support( 'post-thumbnails' );

add_theme_support( 'title-tag' );

// Add theme support for selective refresh for widgets.
add_theme_support( 'customize-selective-refresh-widgets' );

/**
 * Load breadcrumb_trail File
 */
if (!function_exists('breadcrumb_trail')) {
   require get_stylesheet_directory() . '/library/breadcrumbs/breadcrumbs.php';
}
/**
register_menus - register menus
***/
function scorpio_register_menus() {
  register_nav_menus(
    array(
    	'header-menu' => __( 'Primary' ),
    	'top-menu' => __( 'Toggle Menu' ),
    	//'footer-menu' => __( 'Footer Menu' )
     )

  );
}
add_action( 'init', 'scorpio_register_menus' );

function theme_scorpio_scripts() {
	wp_enqueue_style( 'bootstrap', 'https://cdn.jsdelivr.net/npm/bootstrap@5.0.0-beta3/dist/css/bootstrap.min.css' );
	wp_enqueue_style( 'ionicons', get_template_directory_uri() . '/assets/css/plugins/ionicons.min.css' );
	wp_enqueue_style( 'meanmenu', get_template_directory_uri() . '/assets/css/plugins/meanmenu.css' );
	wp_enqueue_style( 'jquery-ui', 'https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.min.css' );
	wp_enqueue_style( 'owl-carousel', 'https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.2.1/assets/owl.carousel.min.css' );
	wp_enqueue_style( 'nice-select', 'https://cdnjs.cloudflare.com/ajax/libs/jquery-nice-select/1.1.0/css/nice-select.min.css' );
	wp_enqueue_style( 'slick', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick.min.css' );
	//wp_enqueue_style( 'plugins', get_template_directory_uri() . '/assets/css/vendor/plugins.min.css' );
  wp_enqueue_style( 'iconfont', get_template_directory_uri() . '/assets/css/vendor/iconfont.min.css' );
  wp_enqueue_style( 'styles', get_template_directory_uri() . '/assets/css/style.min.css' );
wp_enqueue_style( 'responsive', get_template_directory_uri() . '/assets/css/responsive.min.css' );
	wp_enqueue_style( 'style', get_template_directory_uri() . '/style.css' );
	
	wp_enqueue_script('jquery', get_template_directory_uri() . '/assets/js/vendor/jquery-3.5.1.min.js', null, null, false );
  wp_enqueue_script('modernizr', get_template_directory_uri() . '/assets/js/vendor/modernizr-3.7.1.min.js', null, null, false );
  wp_enqueue_script('bootstrap', 'https://cdn.jsdelivr.net/npm/bootstrap@5.0.0-beta3/dist/js/bootstrap.min.js', null, null, true );
	wp_enqueue_script('popper', 'https://cdnjs.cloudflare.com/ajax/libs/popper.js/2.6.0/umd/popper.min.js', null, null, true );
	wp_enqueue_script('meanmenu', get_template_directory_uri() . '/assets/js/plugins/meanmenu.js', array(), '', true );
	wp_enqueue_script('owl', 'https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/owl.carousel.min.js', null, null, true );
	wp_enqueue_script('nice-select', 'https://cdnjs.cloudflare.com/ajax/libs/jquery-nice-select/1.1.0/js/jquery.nice-select.min.js', null, null, true );
	wp_enqueue_script('elevatezoom', 'https://cdnjs.cloudflare.com/ajax/libs/elevatezoom/2.2.3/jquery.elevatezoom.min.js', null, null, true );
	wp_enqueue_script('jquery-ui', 'https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.min.js', null, null, true );
	wp_enqueue_script('slick', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick.min.js', null, null, true );
	wp_enqueue_script('scrollUp', 'https://cdnjs.cloudflare.com/ajax/libs/scrollup/2.4.1/jquery.scrollUp.min.js', null, null, true );
	
	wp_enqueue_script('script', get_template_directory_uri() . '/assets/js/main.js', array(), '', true );
}
add_action( 'wp_enqueue_scripts', 'theme_scorpio_scripts' );

/****
widgets_init - register widgets
****/
function scorpio_widgets_init() {
	// main sidebar
	register_sidebar (array(
		'name'          => __('Sidebar','rm'),
		'id'            => "sidebar-widget-area",
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<div class="widget-title"><h3 class="widgettitle">',
		'after_title'   => '</h3></div>' )
		);
		// Newsletter widget area
	register_sidebar (array(
		'name'          => __('Newsletter Widget Area','scorpio'),
		'id'            => "newsletter-widget-area",
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
    'before_title'  => '<h4 class="mb-3">',
		'after_title'   => '</h4>' )
		);
	// Shop widget area
	register_sidebar (array(
		'name'          => __('Shop page Widget Area','scorpio'),
		'id'            => "shop-widget-area",
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
    'before_title'  => '<h4 class="mb-3">',
		'after_title'   => '</h4>' )
		);
	// first footer widget area
	register_sidebar (array(
		'name'          => __('First Footer Widget Area','scorpio'),
		'id'            => "footer-first-widget-area",
		'before_widget' => '<div id="%1$s" class="widget footer-widget about-widget mb-4 %2$s">',
		'after_widget'  => '</div>',
    'before_title'  => '<h4 class="mb-3">',
		'after_title'   => '</h4>' )
		);
	// second footer widget area
	register_sidebar (array(
		'name'          => __('Second Footer Widget Area','rm'),
		'id'            => "footer-second-widget-area",
		'before_widget' => '<div id="%1$s" class="widget footer-widget address mb-4 %2$s">',
		'after_widget'  => '</div>',
    'before_title'  => '<h4 class="mb-3">',
		'after_title'   => '</h4>' )
		);
	// third footer widget area
	register_sidebar (array(
		'name'          => __('Third Footer Widget Area','rm'),
		'id'            => "footer-third-widget-area",
		'before_widget' => '<div id="%1$s" class="widget footer-widget links-widget footer-list mb-4 %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h4 class="mb-3">',
		'after_title'   => '</h4>' )
		);
}
add_action('init', 'scorpio_widgets_init');

function scorpio_sanitize_dropdown_pages( $page_id, $setting ) {
  // Ensure $input is an absolute integer.
  $page_id = absint( $page_id );
  // If $page_id is an ID of a published page, return it; otherwise, return the default.
  return ( 'publish' == get_post_status( $page_id ) ? $page_id : $setting->default );
}

function scorpio_customize_register( $wp_customize ) {
	require_once get_stylesheet_directory() . '/dropdown-category.php';

	//topbar section panel
	$wp_customize->add_panel( 'mytheme_top_sec', array(
	    'priority' => 100,
	    'capability' => 'edit_theme_options',
	    'theme_supports' => '',
	    'title' => __( 'Topbar Setting', 'mytheme' ),
	    'description' => __( 'Add setting of topbar.', 'mytheme' ),
	) );
	//contact detail section
	$wp_customize->add_section('mytheme_contact_section',array(
		'title'	=> __('Contact details','mytheme'),
		'description'=> __('This section will add contact details of the site.','mytheme'),
		'panel' => 'mytheme_top_sec',
	));
	//phone number
	$wp_customize->add_setting('mytheme_phone_num',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mytheme_phone_num',array(
		'label'	=> __('Phone Number','mytheme'),
		'section'=> 'mytheme_contact_section',
		'setting'=> 'mytheme_phone_num',
		'type'=> 'text'
	));
	//email
	$wp_customize->add_setting('mytheme_email_id',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mytheme_email_id',array(
		'label'	=> __('Email','mytheme'),
		'section'=> 'mytheme_contact_section',
		'setting'=> 'mytheme_email_id',
		'type'=> 'text'
	));
	//open hours
	$wp_customize->add_setting('mytheme_open_hours',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mytheme_open_hours',array(
		'label'	=> __('Open Time','mytheme'),
		'section'=> 'mytheme_contact_section',
		'setting'=> 'mytheme_open_hours',
		'type'=> 'text'
	));


	//social media section
	$wp_customize->add_section('mytheme_social_section',array(
		'title'	=> __('Social Media links','mytheme'),
		'description'=> __('This section will add social media links of the site.','mytheme'),
		'panel' => 'mytheme_top_sec',
	));

	//Facebook
	$wp_customize->add_setting('mytheme_facebook_link',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mytheme_facebook_link',array(
		'label'	=> __('Facebook','mytheme'),
		'section'=> 'mytheme_social_section',
		'setting'=> 'mytheme_facebook_link',
		'type'=> 'text'
	));
	//Twitter
	$wp_customize->add_setting('mytheme_twitter_link',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mytheme_twitter_link',array(
		'label'	=> __('Twitter','mytheme'),
		'section'=> 'mytheme_social_section',
		'setting'=> 'mytheme_twitter_link',
		'type'=> 'text'
	));
	//instagram
	$wp_customize->add_setting('mytheme_instagram_link',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mytheme_instagram_link',array(
		'label'	=> __('Instagram','mytheme'),
		'section'=> 'mytheme_social_section',
		'setting'=> 'mytheme_instagram_link',
		'type'=> 'text'
	));
	//pinterest
	$wp_customize->add_setting('mytheme_pinterest_link',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mytheme_pinterest_link',array(
		'label'	=> __('Pinterest','mytheme'),
		'section'=> 'mytheme_social_section',
		'setting'=> 'mytheme_pinterest_link',
		'type'=> 'text'
	));


	//theme section panel
	$wp_customize->add_panel( 'mytheme_home_sec', array(
	    'priority' => 100,
	    'capability' => 'edit_theme_options',
	    'theme_supports' => '',
	    'title' => __( 'Home Page Sections Setting', 'mytheme' ),
	    'description' => __( 'Add setting of home page sections.', 'mytheme' ),
	) );

	//Features section
	$wp_customize->add_section('mytheme_features_section1',array(
		'title'	=> __('Features','mytheme'),
		'description'=> __('This section will display Feature Content of the site.','mytheme'),
		'panel' => 'mytheme_home_sec',
	));

// Features section pages
	for ( $count = 1; $count <= 4; $count++ ) {

		$wp_customize->add_setting( 'mytheme_features1' . $count, array(
			'default'           => '',
			'sanitize_callback' => 'absint'
		));
		$wp_customize->add_control( 'mytheme_features1' . $count, array(
			'label'    => __( 'Select Feature page '. $count, 'mytheme' ),
			'section'  => 'mytheme_features_section1',
			'type'     => 'dropdown-pages'
		));
	}


	//home about section
	$wp_customize->add_section('mytheme_about_section',array(
		'title'	=> __('About Section','mytheme'),
		'description'=> __('This section will display Welcome Content of the site.','mytheme'),
		'panel' => 'mytheme_home_sec',
	));
//section title
	$wp_customize->add_setting('mytheme_about_section_title',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mytheme_about_section_title',array(
		'label'	=> __('Section Title','mytheme'),
		'section'=> 'mytheme_about_section',
		'setting'=> 'mytheme_about_section_title',
		'type'=> 'text'
	));
//section subtitle
	/* $wp_customize->add_setting('mytheme_about_section_subtitle',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mytheme_about_section_subtitle',array(
		'label'	=> __('Section Sub Title','mytheme'),
		'section'=> 'mytheme_about_section',
		'setting'=> 'mytheme_about_section_subtitle',
		'type'=> 'text'
	)); */
	//about section page
	$wp_customize->add_setting( 'mytheme_about', array(
			'default'           => '',
			'sanitize_callback' => 'scorpio_sanitize_dropdown_pages'
		));
		$wp_customize->add_control( 'mytheme_about', array(
			'label'    => __( 'Select About content Page', 'mytheme' ),
			'section'  => 'mytheme_about_section',
			'type'     => 'dropdown-pages'
		));


		//Services section
	$wp_customize->add_section('mytheme_features_section2',array(
		'title'	=> __('Services','mytheme'),
		'description'=> __('This section will display service Content of the site.','mytheme'),
		'panel' => 'mytheme_home_sec',
	));

// Services section pages
	for ( $count = 1; $count <= 10; $count++ ) {

		$wp_customize->add_setting( 'mytheme_features2' . $count, array(
			'default'           => '',
			'sanitize_callback' => 'absint'
		));
		$wp_customize->add_control( 'mytheme_features2' . $count, array(
			'label'    => __( 'Select service page '. $count, 'mytheme' ),
			'section'  => 'mytheme_features_section2',
			'type'     => 'dropdown-pages'
		));
	}

		//home testimonials section
	$wp_customize->add_section('mytheme_testimonials_section',array(
		'title'	=> __('Testimonials Section','mytheme'),
		'description'=> __('This section will display testimonials of the page.','mytheme'),
		'panel' => 'mytheme_home_sec',
	));
	//section title
	$wp_customize->add_setting('mytheme_testimonials_section_title',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mytheme_testimonials_section_title',array(
		'label'	=> __('Section Title','mytheme'),
		'section'=> 'mytheme_testimonials_section',
		'setting'=> 'mytheme_testimonials_section_title',
		'type'=> 'text'
	));
	//section sub-title
	$wp_customize->add_setting('mytheme_testimonials_section_subtitle',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mytheme_testimonials_section_subtitle',array(
		'label'	=> __('Section Sub-title','mytheme'),
		'section'=> 'mytheme_testimonials_section',
		'setting'=> 'mytheme_testimonials_section_subtitle',
		'type'=> 'text'
	));

	//home blogs section
	$wp_customize->add_section('mytheme_blogs_section',array(
		'title'	=> __('Blogs Section','mytheme'),
		'description'=> __('This section will display blogs of the page.','mytheme'),
		'panel' => 'mytheme_home_sec',
	));
	//section title
	$wp_customize->add_setting('mytheme_blogs_section_title',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mytheme_blogs_section_title',array(
		'label'	=> __('Section Title','mytheme'),
		'section'=> 'mytheme_blogs_section',
		'setting'=> 'mytheme_blogs_section_title',
		'type'=> 'text'
	));

	$wp_customize->add_setting( 'home_blogs_category', array(
		'default'           => 0,
		'sanitize_callback' => 'absint',
	) );
	$wp_customize->add_control( new My_Dropdown_Category_Control( $wp_customize, 'home_blogs_category', array(
		'section'=> 'mytheme_blogs_section',
		'label'         => esc_html__( 'Blogs posts category', 'mytheme' ),
		'description'   => esc_html__( 'Select the category that the blogs will show posts from. If no category is selected, the blogs will be disabled.'),
		// Uncomment to pass arguments to wp_dropdown_categories()
		//'dropdown_args' => array(
		//	'taxonomy' => 'post_tag',
		//),
	) ) );
}
//add_action('customize_register', 'mytheme_customize_register');


add_post_type_support( 'page', 'excerpt' );

	
add_theme_support( 'woocommerce');
add_theme_support( 'wc-product-gallery-zoom' );
add_theme_support( 'wc-product-gallery-lightbox' );
add_theme_support( 'wc-product-gallery-slider' );

if ( ! function_exists( 'scorpio_cart_link_fragment' ) ) {
	/**
	 * Cart Fragments
	 * Ensure cart contents update when products are added to the cart via AJAX
	 *
	 * @param  array $fragments Fragments to refresh via AJAX.
	 * @return array            Fragments to refresh via AJAX
	 */
	function scorpio_cart_link_fragment( $fragments ) {
		global $woocommerce;

		ob_start();
		scorpio_shop_cart_total_item();
		$fragments['a.count-cart'] = ob_get_clean();

		/* ob_start();
		storefront_handheld_footer_bar_cart_link();
		$fragments['a.footer-cart-contents'] = ob_get_clean(); */

		return $fragments;
	}
}
add_filter('woocommerce_add_to_cart_fragments', 'scorpio_cart_link_fragment');

    if ( ! function_exists( 'scorpio_shop_cart_total_item' ) ){
		 function scorpio_shop_cart_total_item(){
		   global $woocommerce;
		  ?>
		 <a href="#" class="count-cart"><i class="dlicon shopping_cart-modern"></i><span class="product-count"><?php echo esc_html($woocommerce->cart->cart_contents_count); ?></span><span class="product-total-price"><?php echo wp_kses_post( WC()->cart->get_cart_subtotal() ); ?></span></a>       
		  <?php }
		}

		add_action( 'scorpio_cart_count','scorpio_shop_cart_total_item');

add_filter('woocommerce_add_to_cart_fragments', 'scorpio_shop_add_to_cart_dropdown_fragment');
function scorpio_shop_add_to_cart_dropdown_fragment( $fragments ){
   ob_start();
   ?>
   <div class="mini-cart-content">
       <?php woocommerce_mini_cart(); ?>
	   
   </div>
   <?php $fragments['div.mini-cart-content'] = ob_get_clean();

   return $fragments;

}
/* function scorpio_shop_woo_cart_product(){
global $woocommerce;
?>
<div id="scorpio-cart" class="scorpio-cart">
<div class="scorpio-quickcart-dropdown">
<?php
woocommerce_mini_cart();
?>
</div>
</div>
    <?php
} */
//add_action( 'scorpio_shop_woo_cart', 'scorpio_shop_woo_cart_product' );


/* add_filter('woocommerce_add_to_cart_fragments', 'scorpio_shop_add_to_cart_dropdown_fragment');
function scorpio_shop_add_to_cart_dropdown_fragment( $fragments ){
   ob_start();
   ?>
   <div class="widget_shopping_cart_content">
       <?php woocommerce_mini_cart(); ?>
	   
   </div>
   <?php $fragments['div.widget_shopping_cart_content'] = ob_get_clean();

   return $fragments;

}

add_filter('woocommerce_add_to_cart_fragments', 'woocommerce_add_to_cart_count_fragments');
function woocommerce_add_to_cart_count_fragments( $fragments ){
   global $woocommerce;
   $productadd       = wp_kses_data($woocommerce->cart->cart_contents_count);
   ob_start();
   ?>

   <span class="product-count"><?php echo esc_html( $productadd); ?></span>

 <?php $fragments['span.product-count'] = ob_get_clean();

   return $fragments;

} */
function scorpio_add_to_cart_loop_button(){
  global $product;
  ?>
  <a href="<?php echo esc_url( $product->add_to_cart_url() ); ?>" class="product-button hintT-top" data-hint="Add to Cart"><i class="fa fa-shopping-cart"></i></a>

<?php }
//add_action( 'scorpio_cart_loop','scorpio_add_to_cart_loop_button');

if ( ! function_exists( 'scorpio_woocommerce_template_loop_product_title' ) ) {

	/**
	 * Show the product title in the product loop. By default this is an H2.
	 */
	function scorpio_woocommerce_template_loop_product_title() {
		echo '<h3 class="' . esc_attr( apply_filters( 'woocommerce_product_loop_title_classes', 'woocommerce-loop-product__title title product-link text-center' ) ) . '">' . get_the_title() . '</h3>'; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
	}
}
remove_action( 'woocommerce_shop_loop_item_title', 'woocommerce_template_loop_product_title', 10 );
add_action( 'woocommerce_shop_loop_item_title','scorpio_woocommerce_template_loop_product_title');

// Hook in
add_filter( 'woocommerce_default_address_fields' , 'custom_override_default_address_fields' );

// Our hooked in function - $address_fields is passed via the filter!
function custom_override_default_address_fields( $address_fields ) {
     $address_fields['state']['required'] = false;

     return $address_fields;
}
class My_Walker_Nav_Menu extends Walker_Nav_Menu {
  function start_lvl(&$output, $depth=0, $args = array()) {
    $indent = str_repeat("\t", $depth);
    $output .= "\n$indent<ul class=\"sub-menu\">\n";
  }
}
class My_Walker_Nav_Menu_Mobile extends Walker_Nav_Menu {
  function start_lvl(&$output, $depth=0, $args = array()) {
    $indent = str_repeat("\t", $depth);
    $output .= "\n$indent<ul class=\"category-mega-menu\">\n";
  }
}


// Hook in
add_filter( 'woocommerce_checkout_fields' , 'custom_override_checkout_fields' );

// Our hooked in function – $fields is passed via the filter!
function custom_override_checkout_fields( $fields ) {
     $fields['shipping']['shipping_phone'] = array(
        'label'     => __('Mobile Number', 'woocommerce'),
    //'placeholder'   => _x('Shipping Mobile Number', 'placeholder', 'woocommerce'),
    'required'  => true,
    'class'     => array('form-row-wide'),
    'clear'     => true
     );
     $fields['billing']['billing_alternate_phone'] = array(
        'label'     => __('Alternate Mobile Number', 'woocommerce'),
    //'placeholder'   => _x('Shipping Mobile Number', 'placeholder', 'woocommerce'),
    'required'  => true,
    'class'     => array('form-row-first'),
    'clear'     => true
     );
	 $fields['billing']['billing_whatsapp_number'] = array(
        'label'     => __('Whatsapp Number', 'woocommerce'),
    //'placeholder'   => _x('Shipping Mobile Number', 'placeholder', 'woocommerce'),
    'required'  => true,
    'class'     => array('form-row-last'),
    'clear'     => true
     );

     return $fields;
     //return $fields2;
	
}

/**
 * Display field value on the order edit page
 */
 
add_action( 'woocommerce_admin_order_data_after_shipping_address', 'my_custom_checkout_field_display_admin_order_meta', 10, 1 );

function my_custom_checkout_field_display_admin_order_meta($order){
    echo '<p><strong>'.__('Shipping Mobile Number').':</strong> ' . get_post_meta( $order->get_id(), '_shipping_phone', true ) . '</p>';
	echo '<p><strong>'.__('Alternate Mobile Number').':</strong> ' . get_post_meta( $order->get_id(), '_billing_alternate_phone', true ) . '</p>';
	echo '<p><strong>'.__('Whatsapp Number').':</strong> ' . get_post_meta( $order->get_id(), '_billing_whatsapp_number', true ) . '</p>';
}

add_action('woocommerce_checkout_process', 'my_custom_checkout_field_process');

function my_custom_checkout_field_process() {
    // Check if set, if its not set add an error.
    if ( ! $_POST['shipping_phone'] )
        wc_add_notice( __( 'Please enter shipping mobile number.' ), 'error' );
	if ( ! $_POST['billing_alternate_phone'] )
        wc_add_notice( __( 'Please enter alternate mobile number.' ), 'error' );
	if ( ! $_POST['billing_whatsapp_number'] )
        wc_add_notice( __( 'Please enter whatsapp number.' ), 'error' );
}
add_action('woocommerce_after_order_notes', 'custom_tailor');
function custom_tailor(){
	?>
<div class="tailor text-center">
	<h4>
		Blouse Tailoring Available, Contact us for Blouse Tailing.
	</h4>
	
</div>
<?php
}
?>
