<?php
add_theme_support( 'custom-logo' );
// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );
add_theme_support( 'post-thumbnails' );
add_theme_support( 'title-tag' );
// Add theme support for selective refresh for widgets.
	add_theme_support( 'customize-selective-refresh-widgets' );
/**
 * Load breadcrumb_trail File
 */
if (!function_exists('breadcrumb_trail')) {
   require get_stylesheet_directory() . '/library/breadcrumbs/breadcrumbs.php';
}
/**********************************************************************************
wpmu_register_menus - register menus
**********************************************************************************/
function wpmu_register_menus() {
  register_nav_menus(
    array( 
    	'header-menu' => __( 'Primary' ),
    	'top-menu' => __( 'Top Menu' ),
    	'footer-menu' => __( 'Footer Menu' )
     )

  );
}
add_action( 'init', 'wpmu_register_menus' );

function theme_edu_scripts() {
	//wp_enqueue_style( 'font-awesome', get_template_directory_uri() . '/assets/css/font-awesome.css' );
	wp_enqueue_style( 'themify', get_template_directory_uri() . '/assets/css/themify.css' );
	wp_enqueue_style( 'slick', get_template_directory_uri() . '/assets/css/slick.css' );
	wp_enqueue_style( 'slick-theme', get_template_directory_uri() . '/assets/css/slick-theme.css' );
	wp_enqueue_style( 'animate', get_template_directory_uri() . '/assets/css/animate.css' );
	wp_enqueue_style( 'bootstrap', get_template_directory_uri() . '/assets/css/bootstrap.css' );
	wp_enqueue_style( 'color6', get_template_directory_uri() . '/assets/css/color6.css' );
	wp_enqueue_style( 'style', get_template_directory_uri() . '/style.css' );
	/*wp_enqueue_script('modernizr', get_template_directory_uri() . '/assets/js/vendor/modernizr-2.8.3.min.js', array(), '', false );*/	
	
	wp_enqueue_script('jquery', get_template_directory_uri() . '/assets/js/jquery-3.3.1.min.js', array(), '', true );
	wp_enqueue_script('popper', get_template_directory_uri() . '/assets/js/popper.min.js', array(), '', true );
	wp_enqueue_script('bootstrap', get_template_directory_uri() . '/assets/js/bootstrap.js', array(), '', true );
	wp_enqueue_script('bootstrap-notify', get_template_directory_uri() . '/assets/js/bootstrap-notify.min.js', array(), '', true );
	wp_enqueue_script('menu', get_template_directory_uri() . '/assets/js/menu.js', array(), '', true );
	wp_enqueue_script('slick', get_template_directory_uri() . '/assets/js/slick.js', array(), '', true );
	wp_enqueue_script('modal', get_template_directory_uri() . '/assets/js/modal.js', array(), '', true );
	wp_enqueue_script('slider-animat-one', get_template_directory_uri() . '/assets/js/slider-animat-one.js', array(), '', true );
	wp_enqueue_script('script', get_template_directory_uri() . '/assets/js/script.js', array(), '', true );

	wp_enqueue_script('custom script', get_template_directory_uri() . '/js/custom.js', array(), '', true );
}
add_action( 'wp_enqueue_scripts', 'theme_edu_scripts' );

/**********************************************************************************
wpmu_widgets_init - register widgets
**********************************************************************************/
function wpmu_widgets_init() {
	// widget area in header
	register_sidebar (array(
		'name'          => __('Header Widget Area','rm'),
		'id'            => "header-widget-area",
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<div class="widget-title"><h3 class="widgettitle">',
		'after_title'   => '</h3></div>' )
		);
	// main sidebar
	register_sidebar (array(
		'name'          => __('Sidebar','rm'),
		'id'            => "sidebar-widget-area",
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<div class="widget-title"><h3 class="widgettitle">',
		'after_title'   => '</h3></div>' )
		);
	// first footer widget area
	register_sidebar (array(
		'name'          => __('First Footer Widget Area','scorpio'),
		'id'            => "footer-first-widget-area",
		'before_widget' => '<div id="%1$s" class="widget footer-widget about-widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3>',
		'after_title'   => '</h3>' )
		);
	// second footer widget area
	register_sidebar (array(
		'name'          => __('Second Footer Widget Area','rm'),
		'id'            => "footer-second-widget-area",
		'before_widget' => '<div id="%1$s" class="widget footer-widget links-widget footer-list %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3>',
		'after_title'   => '</h3>' )
		);
	// third footer widget area
	register_sidebar (array(
		'name'          => __('Third Footer Widget Area','rm'),
		'id'            => "footer-third-widget-area",
		'before_widget' => '<div id="%1$s" class="widget footer-widget links-widget footer-list %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3>',
		'after_title'   => '</h3>' )
		);
	// fourth footer widget area
	register_sidebar (array(
		'name'          => __('Fourth Footer Widget Area','rm'),
		'id'            => "footer-fourth-widget-area",
		'before_widget' => '<div id="%1$s" class="widget footer-widget info-widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3>',
		'after_title'   => '</h3>' )
		);
		
		// Social links widget area
	register_sidebar (array(
		'name'          => __('Social media links','rm'),
		'id'            => "social-widget-area",
		'before_widget' => '<div id="%1$s" class="widget widget_social_icon %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<div class="widget-title"><h3 class="widgettitle">',
		'after_title'   => '</h3></div>' )
		);
}
add_action('init', 'wpmu_widgets_init');
function mytheme_sanitize_dropdown_pages( $page_id, $setting ) {
  // Ensure $input is an absolute integer.
  $page_id = absint( $page_id );
  // If $page_id is an ID of a published page, return it; otherwise, return the default.
  return ( 'publish' == get_post_status( $page_id ) ? $page_id : $setting->default );
}
function mytheme_customize_register( $wp_customize ) {
	require_once get_stylesheet_directory() . '/dropdown-category.php';
	//topbar section panel
	$wp_customize->add_panel( 'mytheme_top_sec', array(
	    'priority' => 100,
	    'capability' => 'edit_theme_options',
	    'theme_supports' => '',
	    'title' => __( 'Topbar Setting', 'mytheme' ),
	    'description' => __( 'Add setting of topbar.', 'mytheme' ),
	) );
	//contact detail section
	$wp_customize->add_section('mytheme_contact_section',array(
		'title'	=> __('Contact details','mytheme'),
		'description'=> __('This section will add contact details of the site.','mytheme'),
		'panel' => 'mytheme_top_sec',
	));
	//phone number
	$wp_customize->add_setting('mytheme_phone_num',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('mytheme_phone_num',array(
		'label'	=> __('Phone Number','mytheme'),
		'section'=> 'mytheme_contact_section',
		'setting'=> 'mytheme_phone_num',
		'type'=> 'text'
	));
	//Facebook
	$wp_customize->add_setting('mytheme_email_id',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('mytheme_email_id',array(
		'label'	=> __('Email','mytheme'),
		'section'=> 'mytheme_contact_section',
		'setting'=> 'mytheme_email_id',
		'type'=> 'text'
	));
	//open hours
	$wp_customize->add_setting('mytheme_open_hours',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('mytheme_open_hours',array(
		'label'	=> __('Open Time','mytheme'),
		'section'=> 'mytheme_contact_section',
		'setting'=> 'mytheme_open_hours',
		'type'=> 'text'
	));
	//social media section
	$wp_customize->add_section('mytheme_social_section',array(
		'title'	=> __('Social Media links','mytheme'),
		'description'=> __('This section will add social media links of the site.','mytheme'),
		'panel' => 'mytheme_top_sec',
	));
	//Facebook
	$wp_customize->add_setting('mytheme_facebook_link',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('mytheme_facebook_link',array(
		'label'	=> __('Facebook','mytheme'),
		'section'=> 'mytheme_social_section',
		'setting'=> 'mytheme_facebook_link',
		'type'=> 'text'
	));
	//Twitter
	$wp_customize->add_setting('mytheme_twitter_link',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('mytheme_twitter_link',array(
		'label'	=> __('Twitter','mytheme'),
		'section'=> 'mytheme_social_section',
		'setting'=> 'mytheme_twitter_link',
		'type'=> 'text'
	));
	//instagram
	$wp_customize->add_setting('mytheme_instagram_link',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('mytheme_instagram_link',array(
		'label'	=> __('Instagram','mytheme'),
		'section'=> 'mytheme_social_section',
		'setting'=> 'mytheme_instagram_link',
		'type'=> 'text'
	));
	//pinterest
	$wp_customize->add_setting('mytheme_pinterest_link',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('mytheme_pinterest_link',array(
		'label'	=> __('Pinterest','mytheme'),
		'section'=> 'mytheme_social_section',
		'setting'=> 'mytheme_pinterest_link',
		'type'=> 'text'
	));

	//theme section panel
	$wp_customize->add_panel( 'mytheme_home_sec', array(
	    'priority' => 100,
	    'capability' => 'edit_theme_options',
	    'theme_supports' => '',
	    'title' => __( 'Home Page Sections Setting', 'mytheme' ),
	    'description' => __( 'Add setting of home page sections.', 'mytheme' ),
	) );

	//Features section
	$wp_customize->add_section('mytheme_features_section1',array(
		'title'	=> __('Features','mytheme'),
		'description'=> __('This section will display Feature Content of the site.','mytheme'),
		'panel' => 'mytheme_home_sec',
	));
	
// Features section pages
	for ( $count = 1; $count <= 4; $count++ ) {

		$wp_customize->add_setting( 'mytheme_features1' . $count, array(
			'default'           => '',
			'sanitize_callback' => 'absint'
		));
		$wp_customize->add_control( 'mytheme_features1' . $count, array(
			'label'    => __( 'Select Feature page '. $count, 'mytheme' ),
			'section'  => 'mytheme_features_section1',
			'type'     => 'dropdown-pages'
		));
	}	

	
	//home about section	
	$wp_customize->add_section('mytheme_about_section',array(
		'title'	=> __('About Section','mytheme'),
		'description'=> __('This section will display Welcome Content of the site.','mytheme'),
		'panel' => 'mytheme_home_sec',
	));	
//section title
	$wp_customize->add_setting('mytheme_about_section_title',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('mytheme_about_section_title',array(
		'label'	=> __('Section Title','mytheme'),
		'section'=> 'mytheme_about_section',
		'setting'=> 'mytheme_about_section_title',
		'type'=> 'text'
	));
//section subtitle
	/* $wp_customize->add_setting('mytheme_about_section_subtitle',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('mytheme_about_section_subtitle',array(
		'label'	=> __('Section Sub Title','mytheme'),
		'section'=> 'mytheme_about_section',
		'setting'=> 'mytheme_about_section_subtitle',
		'type'=> 'text'
	)); */
	//about section page
	$wp_customize->add_setting( 'mytheme_about', array(
			'default'           => '',
			'sanitize_callback' => 'mytheme_sanitize_dropdown_pages'
		));
		$wp_customize->add_control( 'mytheme_about', array(
			'label'    => __( 'Select About content Page', 'mytheme' ),
			'section'  => 'mytheme_about_section',
			'type'     => 'dropdown-pages'
		));		
	
	//home cases section	
	$wp_customize->add_section('mytheme_cases_section',array(
		'title'	=> __('Cases Section','mytheme'),
		'description'=> __('This section will display docctor cases Content of the site.','mytheme'),
		'panel' => 'mytheme_home_sec',
	));	

	//about section page
	$wp_customize->add_setting( 'mytheme_cases', array(
			'default'           => '',
			'sanitize_callback' => 'mytheme_sanitize_dropdown_pages'
		));
		$wp_customize->add_control( 'mytheme_cases', array(
			'label'    => __( 'Select Cases content Page', 'mytheme' ),
			'section'  => 'mytheme_cases_section',
			'type'     => 'dropdown-pages'
		));

		//Services section
	$wp_customize->add_section('mytheme_features_section2',array(
		'title'	=> __('Services','mytheme'),
		'description'=> __('This section will display service Content of the site.','mytheme'),
		'panel' => 'mytheme_home_sec',
	));
	
// Services section pages
	for ( $count = 1; $count <= 10; $count++ ) {

		$wp_customize->add_setting( 'mytheme_features2' . $count, array(
			'default'           => '',
			'sanitize_callback' => 'absint'
		));
		$wp_customize->add_control( 'mytheme_features2' . $count, array(
			'label'    => __( 'Select service page '. $count, 'mytheme' ),
			'section'  => 'mytheme_features_section2',
			'type'     => 'dropdown-pages'
		));
	}	
		
		//home testimonials section	
	$wp_customize->add_section('mytheme_testimonials_section',array(
		'title'	=> __('Testimonials Section','mytheme'),
		'description'=> __('This section will display testimonials of the page.','mytheme'),
		'panel' => 'mytheme_home_sec',
	));	
	//section title
	$wp_customize->add_setting('mytheme_testimonials_section_title',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('mytheme_testimonials_section_title',array(
		'label'	=> __('Section Title','mytheme'),
		'section'=> 'mytheme_testimonials_section',
		'setting'=> 'mytheme_testimonials_section_title',
		'type'=> 'text'
	));
	//section sub-title
	$wp_customize->add_setting('mytheme_testimonials_section_subtitle',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('mytheme_testimonials_section_subtitle',array(
		'label'	=> __('Section Sub-title','mytheme'),
		'section'=> 'mytheme_testimonials_section',
		'setting'=> 'mytheme_testimonials_section_subtitle',
		'type'=> 'text'
	));
		
	//home blogs section	
	$wp_customize->add_section('mytheme_blogs_section',array(
		'title'	=> __('Blogs Section','mytheme'),
		'description'=> __('This section will display blogs of the page.','mytheme'),
		'panel' => 'mytheme_home_sec',
	));	
	//section title
	$wp_customize->add_setting('mytheme_blogs_section_title',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('mytheme_blogs_section_title',array(
		'label'	=> __('Section Title','mytheme'),
		'section'=> 'mytheme_blogs_section',
		'setting'=> 'mytheme_blogs_section_title',
		'type'=> 'text'
	));
	
	$wp_customize->add_setting( 'home_blogs_category', array(
		'default'           => 0,
		'sanitize_callback' => 'absint',
	) );
	$wp_customize->add_control( new My_Dropdown_Category_Control( $wp_customize, 'home_blogs_category', array(
		'section'=> 'mytheme_blogs_section',
		'label'         => esc_html__( 'Blogs posts category', 'mytheme' ),
		'description'   => esc_html__( 'Select the category that the blogs will show posts from. If no category is selected, the blogs will be disabled.'),
		// Uncomment to pass arguments to wp_dropdown_categories()
		//'dropdown_args' => array(
		//	'taxonomy' => 'post_tag',
		//),
	) ) );

	//home programs section	
	$wp_customize->add_section('mytheme_programs_section',array(
		'title'	=> __('Programs Section','mytheme'),
		'description'=> __('This section will display programs of the page.','mytheme'),
		'panel' => 'mytheme_home_sec',
	));	
	//section title
	$wp_customize->add_setting('mytheme_programs_section_title',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('mytheme_programs_section_title',array(
		'label'	=> __('Section Title','mytheme'),
		'section'=> 'mytheme_programs_section',
		'setting'=> 'mytheme_programs_section_title',
		'type'=> 'text'
	));
	
	$wp_customize->add_setting( 'home_programs_category', array(
		'default'           => 0,
		'sanitize_callback' => 'absint',
	) );
	$wp_customize->add_control( new My_Dropdown_Category_Control( $wp_customize, 'home_programs_category', array(
		'section'=> 'mytheme_programs_section',
		'label'         => esc_html__( 'Programs posts category', 'mytheme' ),
		'description'   => esc_html__( 'Select the category that the programs will show posts from. If no category is selected, the programs will be disabled.'),
		// Uncomment to pass arguments to wp_dropdown_categories()
		//'dropdown_args' => array(
		//	'taxonomy' => 'post_tag',
		//),
	) ) );

	
	
}
add_action('customize_register', 'mytheme_customize_register');

add_post_type_support( 'page', 'excerpt' );
class My_Walker_Nav_Menu extends Walker_Nav_Menu {
  function start_lvl(&$output, $depth) {
    $indent = str_repeat("\t", $depth);
    $output .= "\n$indent<ul class=\"submenu\">\n";
  }


}

//add_action( 'wp_footer', 'back_to_top' );
    function back_to_top() {
        echo '<a id="totop" href="#"><i class="fa fa-arrow-circle-up" aria-hidden="true" style="font-size: 40px; color: #ec8922;"></i>
</a>';
    }
    //add_action( 'wp_head', 'back_to_top_style' );
    function back_to_top_style() {
        echo '<style type="text/css">
            #totop {
                position: fixed;
                right: 30px;
                bottom: 30px;
                display: none;
                outline: none;
            }
	
        </style>';
    }
    add_action( 'wp_footer', 'custom_script' );
    function custom_script() {
        echo '<script type="text/javascript">
            jQuery(document).ready(function($){
                $(window).scroll(function () {
                    if ( $(this).scrollTop() > 300 )
                        $("#totop").fadeIn();
                    else
                        $("#totop").fadeOut();
                });
     
                $("#totop").click(function () {
                    $("body,html").animate({ scrollTop: 0 }, 800 );
                    return false;
                });
                $(".menu-item-has-children").addClass("dropdown");
                $(".trail-items").addClass("bread-crumb");
            });
        </script>';
    }
?>