/*! Image Zoooom - v0.2 - 2016-05-11
* Copyright (c) 2016 Diana Burduja; Licensed MIT license 
 
 This is a very strongly modified version of the https://github.com/elevateweb/elevatezoom jQuery plugin. */
(function($,window,document,undefined){"use strict";var ImageZoooom={init:function(options,elem){var self=this;self.elem=elem;self.$elem=$(elem);self.options=options;self.img_big={src:self.$elem.attr("src")};if(self.$elem.data("zoom-image")){self.img_big.src=self.$elem.data("zoom-image")}else if(self.$elem.attr("srcset")){var set=self.$elem.attr("srcset").split(", ");var max_width=0;var max_src="";$.each(set,function(i,src){var parts=$.trim(src).split(" ");if(parseInt(parts[1])>max_width){max_width=parseInt(parts[1]);max_src=parts[0]}});if(max_src!==""){self.img_big.src=max_src}}self.ratio={width:1,height:1};self.zw={height:parseInt(self.options.zoomWindowHeight),width:parseInt(self.options.zoomWindowWidth)};self.lens={height:self.options.lensSize,width:self.options.lensSize};self.screen={height:$(document).height(),width:$(document).width()};if(self.options.tint){self.options.lensColour="none";self.options.lensOpacity="1"}if(self.options.zoomType==="inner"){self.options.showLens=false}self.$elem.parent().removeAttr("title").removeAttr("alt");if(self.options.responsive===true&&self.screen.width<=self.options.responsiveThreshold){self.options.zoomType="inner";self.options.showLens=false}setTimeout(function(){var newImg=new Image;newImg.onload=function(){self.img_big.width=newImg.width;self.img_big.height=newImg.height;self.startZoom()};newImg.src=self.img_big.src},1)},buildZoomContainer:function(){var self=this;self.zoomContainer=$("<div />").addClass("zoomContainer").css({"-webkit-transform":"translateZ(0)",position:"absolute",left:self.img_small.offset.left+"px",top:self.img_small.offset.top+"px",height:self.img_small.height+"px",width:self.img_small.width+"px","z-index":"999"}).appendTo("body")},buildZoomLens:function(){var self=this;if(self.options.containLensZoom){self.zoomContainer.css("overflow","hidden")}var lensStyle={"background-position":"0px 0px","float":"left",display:"none",border:self.options.borderSize+"px solid "+self.options.borderColour,width:self.options.lensSize+"px",height:self.options.lensSize+"px","border-radius":self.options.borderRadius+"px",cursor:self.options.cursor,"background-repeat":"no-repeat",position:"absolute",overflow:"hidden","z-index":"999"};if(self.options.tint===true){lensStyle["-webkit-transform"]="translateZ(0)";lensStyle["opacity"]=self.options.lensOpacity;lensStyle["-ms-filter"]="progid:DXImageTransform.Microsoft.Alpha(Opacity="+self.options.lensOpacity*100+")";lensStyle["filter"]="alpha(opacity= "+self.options.lensOpacity*100+")"}if(self.options.lensShape==="round"){var lensRadius=self.options.lensSize/2+self.options.borderSize+"px";lensStyle["-webkit-border-radius"]=lensRadius;lensStyle["-moz-border-radius"]=lensRadius;lensStyle["border-radius"]=lensRadius}self.zoomLens=$("<div />").addClass("zoomLens").css(lensStyle).appendTo(self.zoomContainer).click(function(){self.$elem.trigger("click")})},buildZoomWindow:function(){var self=this;self.lens.height=self.zw.height/self.ratio.height;if(self.img_big.height<self.zw.height){self.lens.height=self.img_small.height}self.lens.width=self.zw.width/self.ratio.width;if(self.img_big.width<self.zw.width){self.lens.width=self.img_small.width}var lensStyle={"background-position":"0px 0px",display:"none",overflow:"hidden","z-index":"999","-webkit-transform":"translateZ(0)",opacity:self.options.lensOpacity,"-ms-filter":"progid:DXImageTransform.Microsoft.Alpha(Opacity="+self.options.lensOpacity*100+")",filter:"alpha(opacity= "+self.options.lensOpacity*100+")",zoom:1,width:self.lens.width+"px",height:self.lens.height+"px","background-color":self.options.lensColour,cursor:self.options.cursor,"border-radius":self.options.borderRadius+"px",border:self.options.lensBorderSize+"px solid "+self.options.lensBorderColour,"background-repeat":"no-repeat",position:"absolute","box-shadow":"-0px -0px 10px rgba(0, 0, 0, 0.4)"};if(self.options.lensOverlay!==false){lensStyle["background"]="url("+self.options.lensOverlay+") "+self.options.lensColour}self.zoomLens=$("<div />").addClass("zoomLens").css(lensStyle).appendTo(self.zoomContainer).click(function(){self.$elem.trigger("click")});var zoomWindowStyle={overflow:"hidden","background-position":"0px 0px","text-align":"center","background-color":self.options.zoomWindowBgColour,width:self.zw.width+"px",height:self.zw.height+"px","float":"left","border-radius":self.options.borderRadius+"px","background-size":self.img_big.width/self.currentZoomLevel+"px "+self.img_big.height/self.currentZoomLevel+"px",display:"none","z-index":"999",border:self.options.borderSize+"px solid "+self.options.borderColour,"background-repeat":"no-repeat",position:"absolute"};if(self.options.zoomWindowShadow>0){var zoomWindowShadowText=self.options.zoomWindowShadow*2+"px "+self.options.zoomWindowShadow*2+"px "+self.options.zoomWindowShadow+"px #ccc";zoomWindowStyle["box-shadow"]=zoomWindowShadowText;zoomWindowStyle["-moz-box-shadow"]=zoomWindowShadowText;zoomWindowStyle["-webkit-box-shadow"]=zoomWindowShadowText;zoomWindowStyle["-khtml-box-shadow"]=zoomWindowShadowText}return zoomWindowStyle},buildZoomInner:function(){var self=this;var borderWidth=self.$elem.css("border-left-width");var innerStyle={overflow:"hidden","margin-left":borderWidth,"margin-top":borderWidth,"background-position":"0px 0px",width:self.img_small.width+"px",height:self.img_small.height+"px","float":"left","border-radius":self.options.borderRadius+"px",display:"none",cursor:self.options.cursor,"background-repeat":"no-repeat",position:"absolute","z-index":"999"};return innerStyle},buildTint:function(){var self=this;if(!self.options.tint){return}var tintStyle={display:"block",position:"absolute","background-color":self.options.tintColour,filter:"alpha(opacity=0)",border:"none",opacity:0,"z-index":250,width:self.img_small.width+"px",height:self.img_small.height+"px"};self.tintContainer=$("<div />").addClass("tintContainer");self.zoomTint=$("<div />").addClass("zoomTint").css(tintStyle);self.zoomLens.wrap(self.tintContainer);self.zoomLens.after(self.zoomTint);var zoomTintImageCss={position:"absolute",left:"0px",top:"0px","z-index":"250",opacity:"0","max-width":"none",width:self.img_small.width+"px",height:self.img_small.height+"px"};if(self.options.zoomType==="window"){zoomTintImageCss.opacity=1}self.zoomTintImage=$("<img />").css(zoomTintImageCss).attr("src",self.img_big.src).appendTo(self.zoomLens).click(function(){self.$elem.trigger("click")})},startZoom:function(){var self=this;self.isWindowActive=false;self.isLensActive=false;self.isTintActive=false;self.zoomLock=1;self.scrollingLock=false;self.changeBgSize=false;self.currentZoomLevel=self.options.zoomLevel;self.img_small={src:self.$elem.attr("src"),width:self.$elem.width(),height:self.$elem.height(),offset:self.$elem.offset()};self.ratio={width:self.img_big.width/self.img_small.width/self.currentZoomLevel,height:self.img_big.height/self.img_small.height/self.currentZoomLevel};if((self.ratio.height<1||self.ratio.width<1)&&self.options.scrollZoom!==true){return false}self.img_small.offset=self.$elem.offset();self.buildZoomContainer();var zoomWindowStyle={};switch(self.options.zoomType){case"lens":self.buildZoomLens();self.buildTint();break;case"window":zoomWindowStyle=self.buildZoomWindow();self.buildTint();break;case"inner":zoomWindowStyle=self.buildZoomInner();break}var appendTo="body";if(!isNaN(self.options.zoomWindowPosition)){appendTo=self.zoomContainer}self.zoomWindow=$("<div />").addClass("zoomWindow").css(zoomWindowStyle).appendTo(appendTo).click(function(){self.$elem.trigger("click")});var customText=$("<div />").addClass("iz_watermark").css({width:self.img_small.width+"px",height:self.img_small.height+"px","vertical-align":self.options.customTextVAlign,display:"table-cell","text-align":self.options.customTextAlign,color:self.options.customTextColor,"font-size":self.options.customTextSize+"px",padding:"3px"}).html(self.options.customText);if($(".iz_watermark").length>0){$(".iz_watermark").remove()}self.zoomWindow.after(customText);self.zoomWindowContainer=$("<div/>").addClass("zoomWindowContainer").css("width",self.zw.width);self.zoomWindow.wrap(self.zoomWindowContainer);var backgroundImage={backgroundImage:"url('"+self.img_big.src+"')"};if(self.options.zoomType==="lens"){self.zoomLens.css(backgroundImage)}else{self.zoomWindow.css(backgroundImage)}self.registerTouchEvents();self.registerMouseEvents();self.registerScrollZoom();self.zoomContainer.add(self.$elem).mouseenter(function(){self.setElements(true)}).mouseleave(function(){if(!self.scrollLock){self.setElements(false)}});if(self.options.zoomType!=="inner"){self.zoomWindow.mouseenter(function(){self.setElements(false)})}else{self.showZoomWindow(false)}},registerTouchEvents:function(){var self=this;self.zoomContainer.bind("touchstart",function(e){e.preventDefault();var touch=e.originalEvent.touches[0]||e.originalEvent.changedTouches[0];self.mouse={left:parseInt(touch.pageX-self.img_small.offset.left),top:parseInt(touch.pageY-self.img_small.offset.top)};self.setPosition(touch);self.setElements(true)});self.zoomContainer.bind("touchend",function(){if(!self.scrollLock){self.setElements(false)}});self.zoomContainer.bind("touchmove",function(e){e.preventDefault();var touch=e.originalEvent.touches[0]||e.originalEvent.changedTouches[0];self.mouse={left:parseInt(touch.pageX-self.img_small.offset.left),top:parseInt(touch.pageY-self.img_small.offset.top)};self.setPosition(touch)})},registerMouseEvents:function(){var self=this;var registerMouseMove=function(e){self.mouse={left:parseInt(e.pageX-self.img_small.offset.left),top:parseInt(e.pageY-self.img_small.offset.top)};if(self.lastX!==e.clientX||self.lastY!==e.clientY){self.setPosition(e);self.currentLoc=e}self.lastX=e.clientX;self.lastY=e.clientY};var registerMouseAndShowWindow=function(e){if(self.outOfBound===false){self.setElements(true)}registerMouseMove(e)};self.$elem.bind("mousemove",registerMouseAndShowWindow);self.zoomContainer.bind("mousemove",registerMouseAndShowWindow);if(self.options.zoomType==="inner"){self.zoomWindow.bind("mousemove",registerMouseMove)}else{self.zoomLens.bind("mousemove",registerMouseMove);if(self.options.tint){self.zoomTint.bind("mousemove",registerMouseMove)}}},registerScrollZoom:function(){var self=this;if(!self.options.scrollZoom){return false}if(self.options.zoomLevel!==1){self.changeZoomLevel(self.currentZoomLevel)}var minZoomLevel=self.options.scrollZoomIncrement*2;if(self.options.minZoomLevel){minZoomLevel=self.options.minZoomLevel}var registerScrollZoomEvent=function(e){self.scrollLock=true;clearTimeout($.data(this,"timer"));$.data(this,"timer",setTimeout(function(){self.scrollLock=false},250));var theEvent=e.originalEvent.wheelDelta||e.originalEvent.detail*-1;e.stopImmediatePropagation();e.stopPropagation();e.preventDefault();var changeZoom=0;self.currentZoomLevel=parseFloat(self.currentZoomLevel);if(theEvent>0){if(self.currentZoomLevel>=minZoomLevel){changeZoom=self.currentZoomLevel-self.options.scrollZoomIncrement}}else{changeZoom=self.currentZoomLevel+self.options.scrollZoomIncrement}self.changeZoomLevel(changeZoom);return false};self.zoomContainer.add(self.$elem).bind("mousewheel DOMMouseScroll MozMousePixelScroll",registerScrollZoomEvent)},setElements:function(type){var self=this;if(!self.options.zoomEnabled){return false}if(!self.isWindowSet){return}self.showZoomWindow(type);self.showLens(type);self.showTint(type)},setPosition:function(e){var self=this;if(!self.options.zoomEnabled){return false}if(self.options.tint&&self.options.zoomType!=="inner"){self.zoomTint.css({top:0,left:0})}if(self.options.responsive&&!self.options.scrollZoom&&self.options.showLens){if(self.options.zoomType==="lens"){self.zoomLens.css({width:self.options.lensSize+"px",height:self.options.lensSize+"px"})}else{var lensHeight=self.zw.height/self.ratio.height;if(self.img_small.height<self.zw.width/self.ratio.width){lensHeight=self.img_small.height}var lensWidth=self.zw.width/self.ratio.width;if(self.img_small.width<self.zw.width/self.ratio.height){lensWidth=self.img_small.width}self.zoomLens.css({width:lensWidth+"px",height:lensHeight+"px"});if(self.options.tint){self.zoomTintImage.css({width:self.img_small.width+"px",height:self.img_small.height+"px"})}}}self.zoomContainer.css({top:self.img_small.offset.top,left:self.img_small.offset.left});var bound={top:false,bottom:false,left:false,right:false};if(self.options.zoomType==="window"){bound.height=self.zoomLens.height()/2;bound.width=self.zoomLens.width()/2}if(self.options.zoomType==="inner"){bound.height=self.img_small.height/2/self.ratio.height;bound.width=self.img_small.width/2/self.ratio.width}bound.top=self.mouse.top<bound.height;bound.bottom=self.mouse.top>self.img_small.height-bound.height-self.options.lensBorderSize*2;bound.left=self.mouse.left<bound.width;bound.right=self.mouse.left>self.img_small.width-bound.width-self.options.lensBorderSize*2;self.bound=bound;if(self.mouse.left<=0||self.mouse.top<0||self.mouse.left>self.img_small.width||self.mouse.top>self.img_small.height){self.outOfBound=true;self.setElements(false);return}else{self.outOfBound=false;var lensLeftPos=0;var lensTopPos=0;if(self.options.showLens){lensLeftPos=self.mouse.left-self.zoomLens.width()/2;lensTopPos=self.mouse.top-self.zoomLens.height()/2}if(bound.top){lensTopPos=0}if(bound.left){self.windowLeftPos=0;lensLeftPos=0;self.tintpos=0}switch(self.options.zoomType){case"window":if(bound.bottom){lensTopPos=Math.max(self.img_small.height-self.zoomLens.height()-self.options.lensBorderSize*2,0)}if(bound.right){lensLeftPos=self.img_small.width-self.zoomLens.width()-self.options.lensBorderSize*2}if(self.options.tint){self.setTintPosition(e)}break;case"inner":if(bound.bottom){lensTopPos=Math.max(self.img_small.height-self.options.lensBorderSize*2,0)}if(bound.right){lensLeftPos=-self.options.lensBorderSize*2}break;case"lens":self.windowLeftPos=self.zoomLens.width()/2-self.mouse.left*self.ratio.width;self.windowTopPos=self.zoomLens.height()/2-self.mouse.top*self.ratio.height;self.zoomLens.css({backgroundPosition:self.windowLeftPos+"px "+self.windowTopPos+"px"});self.changeBackgroundSize();if(self.options.tint){self.setTintPosition(e)}break}self.setWindowPosition(e);if(self.options.showLens){if(self.fullwidth&&self.options.zoomType!=="lens"){lensLeftPos=0}self.zoomLens.css({left:lensLeftPos+"px",top:lensTopPos+"px"})}}},showZoomWindow:function(on){var self=this;if(self.isWindowActive===on){return}self.fadeEffect(self.zoomWindow,on,self.options.zoomWindowFadeIn,self.options.zoomWindowFadeOut);self.isWindowActive=on},showLens:function(on){var self=this;if(!self.options.showLens){return}if(self.isLensActive===on){return}self.fadeEffect(self.zoomLens,on,self.options.lensFadeIn,self.options.lensFadeOut);self.isLensActive=on},showTint:function(on){var self=this;if(!self.options.tint||self.options.zoomType==="inner"){return}if(self.isTintActive===on){return}if(on){self.zoomTint.css({opacity:self.options.tintOpacity}).animate()}self.fadeEffect(self.zoomTint,on,"slow","slow");self.isTintActive=on},fadeEffect:function(element,action,time_in,time_out){if(action){if(time_in>0){element.stop(true,true,false).fadeIn(time_in)}else{element.show()}}else{if(time_out>0){element.stop(true,true).fadeOut(time_out)}else{element.hide()}}},setWindowPosition:function(e){var self=this;if(self.options.zoomType==="inner"){self.options.zoomWindowPosition=1}self.options.zoomWindowOffsetx=parseInt(self.options.zoomWindowOffsetx);self.options.zoomWindowOffsety=parseInt(self.options.zoomWindowOffsety);var windowOffsetTop=self.options.zoomWindowOffsety;var windowOffsetLeft=self.img_small.width;if(!isNaN(self.options.zoomWindowPosition)){switch(self.options.zoomWindowPosition){case 4:case 5:case 6:case 7:case 8:windowOffsetTop=self.img_small.height;break;case 12:case 13:case 14:case 15:case 16:windowOffsetTop=-self.zoomWindow.height()-self.options.borderSize*2;break;case 1:case 11:windowOffsetTop=self.options.zoomWindowOffsety;break;case 2:case 10:windowOffsetTop=self.img_small.height/2-self.zw.height/2;break;case 3:case 9:windowOffsetTop=self.img_small.height-self.zoomWindow.height()-self.options.borderSize*2;break}switch(self.options.zoomWindowPosition){case 1:case 2:case 3:case 4:case 16:windowOffsetLeft=self.img_small.width+self.options.zoomWindowOffsetx;if(self.options.responsive===true&&self.options.zoomType==="window"){if(self.$elem.offset().left+windowOffsetLeft+self.zw.width>=self.screen.width){self.zw.width=self.screen.width-self.$elem.offset().left-windowOffsetLeft-20;self.zoomWindow.css({width:self.zw.width});self.zoomLens.css({width:self.zw.width/self.ratio.width})}}break;case 8:case 9:case 10:case 11:case 12:if(self.options.responsive===true&&self.options.zoomType==="window"){if(self.zw.width+self.options.borderSize*2+self.options.zoomWindowOffsetx>=self.$elem.offset().left){self.zw.width=self.$elem.offset().left-self.options.borderSize*2-self.options.zoomWindowOffsetx-20;self.zoomWindow.css({width:self.zw.width});self.zoomLens.css({width:self.zw.width/self.ratio.width})}}windowOffsetLeft=-self.zw.width-self.options.borderSize*2-self.options.zoomWindowOffsetx*2;break;case 5:case 15:windowOffsetLeft=self.img_small.width-self.zoomWindow.width()-self.options.borderSize*2;break;case 6:case 14:windowOffsetLeft=self.img_small.width/2-self.zw.width/2-self.options.borderSize*2;break;case 7:case 13:windowOffsetLeft=0;break}}else{var externalContainer=$("#"+self.options.zoomWindowPosition).offset();windowOffsetTop=externalContainer.top;windowOffsetLeft=externalContainer.left}self.isWindowSet=true;windowOffsetTop=windowOffsetTop+self.options.zoomWindowOffsety;windowOffsetLeft=windowOffsetLeft+self.options.zoomWindowOffsetx;self.zoomWindow.css({top:windowOffsetTop,left:windowOffsetLeft});if(self.options.zoomType==="inner"){self.zoomWindow.css({top:0,left:0})}self.windowLeftPos=self.zoomWindow.width()/2-self.mouse.left*self.ratio.width;self.windowTopPos=self.zoomWindow.height()/2-self.mouse.top*self.ratio.height;if(self.bound.top){self.windowTopPos=0}if(self.bound.left){self.windowLeftPos=0}if(self.bound.bottom){self.windowTopPos=(self.img_big.height/self.currentZoomLevel-self.zoomWindow.height())*-1}if(self.bound.right){self.windowLeftPos=(self.img_big.width/self.currentZoomLevel-self.zoomWindow.width())*-1}if(self.fullheight){self.windowTopPos=0}if(self.fullwidth){self.windowLeftPos=0}if(self.options.zoomType==="window"||self.options.zoomType==="inner"){if(self.zoomLock===1){if(self.ratio.width<=1){self.windowLeftPos=0}if(self.ratio.height<=1){self.windowTopPos=0}}if(self.img_big.height<self.zw.height){self.windowTopPos=0}if(self.img_big.width<self.zw.width){self.windowLeftPos=0}if(self.options.easingAmount>0){self.easingEffect(e)}else{self.changeBackgroundSize();self.zoomWindow.css({backgroundPosition:self.windowLeftPos+"px "+self.windowTopPos+"px"})}}},changeBackgroundSize:function(){var self=this;if(!self.changeBgSize){return}var newvalue=self.newvaluewidth;if(self.img_small.height>self.img_small.width){newvalue=self.newvalueheight}var bgSize={"background-size":self.img_big.width/self.newvalue+"px "+self.img_big.height/self.newvalue+"px"};if(self.options.zoomType==="lens"){self.zoomLens.css(bgSize)}self.zoomWindow.css(bgSize);self.changeBgSize=false},easingEffect:function(){var self=this;if(!self.xp){self.xp=0}if(!self.yp){self.yp=0}if(!self.loop){self.loop=setInterval(function(){self.xp+=(self.windowLeftPos-self.xp)/self.options.easingAmount;self.yp+=(self.windowTopPos-self.yp)/self.options.easingAmount;if(self.scrollingLock){clearInterval(self.loop);self.xp=self.zoomWindow.width()/2-self.mouse.left*self.ratio.width;self.yp=self.zoomWindow.height()/2-self.mouse.top*self.ratio.height;self.changeBackgroundSize();self.zoomWindow.css({backgroundPosition:self.windowLeftPos+"px "+self.windowTopPos+"px"});self.scrollingLock=false;self.loop=false}else{self.changeBackgroundSize();self.zoomWindow.css({backgroundPosition:self.xp+"px "+self.yp+"px"})}},16)}},setTintPosition:function(){var self=this;if(!self.options.tint){return}self.tintpos=self.zoomLens.width()/2-self.mouse.left;self.tintposy=self.zoomLens.height()/2-self.mouse.top;if(self.bound.top||self.fullheight){self.tintposy=0}if(self.bound.left||self.fullwidth){self.tintpos=0}if(self.bound.bottom){self.tintposy=(self.img_small.height-self.zoomLens.height()-self.options.lensBorderSize*2)*-1}if(self.bound.right){self.tintpos=(self.img_small.width-self.zoomLens.width()-self.options.lensBorderSize*2)*-1}self.zoomTintImage.css({left:self.tintpos+"px",top:self.tintposy+"px"})},changeZoomLevel:function(value){var self=this;self.scrollingLock=true;var newvalue=parseFloat(value).toFixed(2);self.newvalue=newvalue;var maxHeight=self.img_big.height/self.zw.height;var maxWidth=self.img_big.width/self.zw.width;if(self.options.zoomType!=="inner"){if(maxHeight<=newvalue){self.newvalueheight=maxHeight;self.fullheight=true}else{self.newvalueheight=newvalue;self.fullheight=false}self.ratio.height=self.img_big.height/self.newvalueheight/self.img_small.height;if(maxWidth<=newvalue){self.newvaluewidth=maxWidth;self.fullwidth=true}else{self.newvaluewidth=newvalue;self.fullwidth=false}self.ratio.width=self.img_big.width/self.newvaluewidth/self.img_small.width}else{maxHeight=parseFloat(self.img_big.height/self.img_small.height).toFixed(2);maxWidth=parseFloat(self.img_big.width/self.img_small.width).toFixed(2);newvalue=Math.min(maxHeight,maxWidth,newvalue);self.newvalueheight=newvalue;self.ratio.height=self.img_big.height/newvalue/self.img_small.height;if(maxHeight<=newvalue){self.fullheight=true}else{self.fullheight=false}self.ratio.width=self.img_big.width/newvalue/self.img_small.width;if(maxWidth<=newvalue){self.newvaluewidth=maxWidth;self.fullwidth=true}else{self.newvaluewidth=newvalue;self.fullwidth=false}}var scrcontinue=true;if(self.options.zoomType==="inner"&&self.newvaluewidth>maxWidth){scrcontinue=false;self.fullheight=true;self.fullwidth=true}if(scrcontinue){self.zoomLock=0;self.changeZoom=true;if(self.zw.height/self.ratio.height<=self.img_small.height){self.currentZoomLevel=self.newvalueheight;self.changeBgSize=true;if(self.options.zoomType==="window"){self.zoomLens.css({height:String(self.zw.height/self.ratio.height)+"px"})}}if(self.zw.width/self.ratio.width<=self.img_small.width){if(self.options.zoomType!=="inner"&&self.newvaluewidth>self.newvalueheight){self.currentZoomLevel=self.newvaluewidth}self.changeBgSize=true;if(self.options.zoomType==="window"){self.zoomLens.css({width:String(self.zw.width/self.ratio.width)+"px"})}}if(self.options.zoomType==="inner"){self.changeBgSize=true;if(self.img_small.width!==self.img_small.height){self.currentZoomLevel=self.newvaluewidth}}}self.setPosition(self.currentLoc)}};$.fn.image_zoom=function(options){return this.each(function(){function F(){}var settings=$.extend(true,{},$.fn.image_zoom.options,options);F.prototype=ImageZoooom;var zoom=new F;zoom.init(settings,this)})};$.fn.image_zoom.options={zoomEnabled:true,zoomLevel:1,scrollZoom:false,scrollZoomIncrement:.1,minZoomLevel:false,maxZoomLevel:false,easingAmount:12,lensSize:200,zoomWindowWidth:400,zoomWindowHeight:360,zoomWindowOffsetx:0,zoomWindowOffsety:0,zoomWindowPosition:1,zoomWindowBgColour:"#fff",zoomWindowShadow:4,lensFadeIn:false,lensFadeOut:false,lensOverlay:false,zoomWindowFadeIn:false,zoomWindowFadeOut:false,zoomWindowAlwaysShow:false,zoomTintFadeIn:false,zoomTintFadeOut:false,borderSize:4,showLens:true,borderColour:"#888",borderRadius:0,lensBorderSize:1,lensBorderColour:"#000",lensShape:"square",zoomType:"window",containLensZoom:false,lensColour:"white",lensOpacity:.4,lenszoom:false,tint:false,tintColour:"#333",tintOpacity:.4,cursor:"default",responsive:false,responsiveThreshold:550,customText:"",customTextSize:12,customTextColor:"#ccc",customTextAlign:"bottom",customTextVAlign:"right",onComplete:$.noop}})(jQuery,window,document);
